package cn.schoolwow.ams.flow.dispatcher.common;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;

public class SetAMSListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Collection<AMSListener> amsListenerCollection = (Collection<AMSListener>) flowContext.checkData("amsListenerList");
        String projectName = (String) flowContext.checkData("projectName");

        for(AMSListener amsListener:amsListenerCollection){
            if(amsListener.projectName().equalsIgnoreCase(projectName)){
                flowContext.putTemporaryData("amsListener", amsListener);
                break;
            }
        }
    }

    @Override
    public String name() {
        return "根据项目名设置AMSListener";
    }
}
