package cn.schoolwow.ams.flow.block;

import cn.schoolwow.ams.flow.block.common.GetOperationFieldFlow;
import cn.schoolwow.ams.flow.block.common.GetResourceFieldFlow;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class AddClassBlockFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject block = (JSONObject) flowContext.checkData("block");
        String tableName = (String) flowContext.checkData("tableName");

        block.put("daoName", "clazz");
        block.put("tableName", tableName);
        setRequestField(flowContext);
        setResponseField(flowContext);
    }

    @Override
    public String name() {
        return "添加pojo类区块";
    }

    private void setRequestField(FlowContext flowContext){
        List<String> existFieldNameList = (List<String>) flowContext.getData("existFieldNameList");
        JSONObject block = (JSONObject) flowContext.checkData("block");
        Class requestClass = (Class) flowContext.getData("requestClass");

        JSONObject fieldMap = new JSONObject(true);
        if(null!=requestClass){
            Field[] entityFields = requestClass.getDeclaredFields();
            Field.setAccessible(entityFields, true);
            for (Field entityField : entityFields) {
                if(Modifier.isTransient(entityField.getModifiers())){
                    continue;
                }
                if(null!=entityField.getAnnotation(Ignore.class)){
                    continue;
                }
                if(!existFieldNameList.isEmpty()&&!existFieldNameList.contains(entityField.getName())){
                    continue;
                }
                JSONObject operationField = (JSONObject) flowContext.startFlow(new GetOperationFieldFlow())
                        .putCurrentCompositeFlowData("entityField", entityField)
                        .execute()
                        .checkData("operationField");
                fieldMap.put(entityField.getName(), operationField);
            }
        }
        block.put("operationFields", fieldMap);
    }

    private void setResponseField(FlowContext flowContext){
        JSONObject block = (JSONObject) flowContext.checkData("block");
        Class responseClass = (Class) flowContext.checkData("responseClass");

        JSONObject fieldMap = new JSONObject(true);
        Field[] entityFields = responseClass.getDeclaredFields();
        Field.setAccessible(entityFields, true);
        for (Field entityField : entityFields) {
            if(Modifier.isTransient(entityField.getModifiers())){
                continue;
            }
            if(null!=entityField.getAnnotation(Ignore.class)){
                continue;
            }
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetResourceFieldFlow())
                    .putCurrentCompositeFlowData("entityField", entityField)
                    .execute()
                    .checkData("resourceField");
            fieldMap.put(entityField.getName(), resourceField);
        }
        block.put("resourceFields", fieldMap);
    }

}
