package cn.schoolwow.ams.domain.listener.table;

import com.alibaba.fastjson.JSONObject;

public class AMSTableListener {
    private JSONObject listener = new JSONObject();

    /**
     * 设置项目名
     * */
    public AMSTableListener projectName(String projectName){
        listener.put("projectName", projectName);
        return this;
    }

    /**
     * 数据库名
     * */
    public AMSTableListener daoName(String daoName){
        listener.put("daoName", daoName);
        return this;
    }
    
    /**
     * 表名
     * */
    public AMSTableListener tableName(String tableName){
        listener.put("tableName", tableName);
        return this;
    }

    /**
     * 数据库表分页查询接口
     * */
    public AMSTableListener listTable(ListTable listTable){
        listener.put("listTable", listTable);
        return this;
    }

    /**
     * 数据库表新增接口
     * */
    public AMSTableListener createTable(CreateTable createTable){
        listener.put("createTable", createTable);
        return this;
    }

    /**
     * 数据库表更新接口
     * */
    public AMSTableListener editTable(EditTable editTable){
        listener.put("editTable", editTable);
        return this;
    }

    /**
     * 数据库表删除接口
     * */
    public AMSTableListener deleteTable(DeleteTable deleteTable){
        listener.put("deleteTable", deleteTable);
        return this;
    }

    public JSONObject getListener(){
        return listener;
    }
}
