package cn.schoolwow.ams.domain.listener.list;

import cn.schoolwow.ams.flow.block.AddClassBlockFlow;
import cn.schoolwow.ams.flow.block.AddDatabaseEntityBlockFlow;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

public class AMSListBlock {
    private JSONObject block = new JSONObject();
    {
        block.put("id", "id");
        block.put("initList", true);
        block.put("blockConfig", new JSONObject());
    }

    private QuickFlow listBlockFlow = QuickFlow.newInstance()
            .putContextData("block", block)
            //过滤请求字段
            .putContextData("existFieldNameList", new ArrayList<>());

    /**指定项目名*/
    public AMSListBlock projectName(String projectName){
        block.put("projectName", projectName);
        return this;
    }

    /**指定显示部分查询字段*/
    public AMSListBlock existFieldName(String... existFieldNames){
        List<String> existFieldNameList = (List<String>) listBlockFlow.getContextData("existFieldNameList");
        existFieldNameList.addAll(Arrays.asList(existFieldNames));
        JSONObject operationFields = block.getJSONObject("operationFields");
        if(null!=operationFields){
            Set<String> keySet = operationFields.keySet();
            Set<String> removeKeySet = new HashSet<>();
            for(String key:keySet){
                if(!existFieldNameList.contains(key)){
                    removeKeySet.add(key);
                }
            }
            for(String key:removeKeySet){
                operationFields.remove(key);
            }
        }
        return this;
    }

    /**添加数据库区块*/
    public AMSListBlock databaseBlock(String daoName, Entity entity){
        listBlockFlow.startFlow(new AddDatabaseEntityBlockFlow())
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entity", entity)
                .execute();
        return this;
    }

    /**添加实体类区块*/
    public AMSListBlock classBlock(Class clazz){
        return classBlock(clazz.getSimpleName(), clazz, clazz);
    }

    /**添加实体类区块*/
    public AMSListBlock classBlock(String tableName, Class requestClass, Class responseClass){
        listBlockFlow.startFlow(new AddClassBlockFlow())
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("requestClass", requestClass)
                .putCurrentCompositeFlowData("responseClass", responseClass)
                .execute();
        return this;
    }

    /**指定主键*/
    public AMSListBlock idField(String idField){
        block.put("id", idField);
        sort(idField, "desc");
        return this;
    }

    /**是否初始化*/
    public AMSListBlock initList(boolean initList){
        block.put("initList", initList);
        return this;
    }

    /**前端默认排序*/
    public AMSListBlock sort(String sortField, String sortOrder){
        JSONObject blockConfig = block.getJSONObject("blockConfig");

        JSONObject data = new JSONObject();
        JSONObject searchs = new JSONObject();
        searchs.put("sortField", sortField);
        searchs.put("sortOrder", sortOrder);
        data.put("searchs", searchs);
        blockConfig.put("data", data);
        return this;
    }

    /**前端分页*/
    public AMSListBlock simulate(){
        JSONObject blockConfig = block.getJSONObject("blockConfig");

        blockConfig.put("pageSize", 10);
        JSONObject props = new JSONObject();
        props.put("pagination", "simulate");
        blockConfig.put("props", props);
        return this;
    }

    /**额外属性,会覆盖默认list配置*/
    public AMSListBlock blockConfig(JSONObject blockConfig){
        block.put("blockConfig", blockConfig);
        return this;
    }

    public JSONObject getBlock(){
        return block;
    }

}
