package cn.schoolwow.ams.domain.listener.clazz;

import com.alibaba.fastjson.JSONObject;

public class AMSClazzListener {
    private JSONObject listener = new JSONObject();

    /**
     * 设置项目名
     * */
    public AMSClazzListener projectName(String projectName){
        listener.put("projectName", projectName);
        return this;
    }

    /**
     * 实体名
     * */
    public AMSClazzListener className(String className){
        listener.put("className", className);
        return this;
    }

    /**
     * 分页请求
     * */
    public AMSClazzListener list(ListClazzListener listClazzListener){
        listener.put("list", listClazzListener);
        return this;
    }

    /**
     * 新增请求
     * */
    public AMSClazzListener create(CreateClazzListener createClazzListener){
        listener.put("create", createClazzListener);
        return this;
    }

    /**
     * 更新请求
     * */
    public AMSClazzListener edit(EditClazzListener editClazzListener){
        listener.put("edit", editClazzListener);
        return this;
    }

    /**
     * 删除请求
     * */
    public AMSClazzListener delete(DeleteClazzListener deleteClazzListener){
        listener.put("delete", deleteClazzListener);
        return this;
    }

    public JSONObject getListener(){
        return listener;
    }
}
