package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SetAMSRemoteSelectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsRemoteSelectArray = (JSONArray) flowContext.getData("amsRemoteSelectArray", new JSONArray());
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsRemoteSelectArray.size();i++){
            JSONObject amsRemoteSelect = amsRemoteSelectArray.getJSONObject(i);

            String[] uniqueKeyFieldList = (String[]) amsRemoteSelect.get("uniqueKeyFieldList");
            if(null==uniqueKeyFieldList||uniqueKeyFieldList.length==0){
                continue;
            }
            for(int j=0;j<blocks.size();j++){
                JSONObject block = blocks.getJSONObject(j);
                String uniqueKey = block.getString("uniqueKey");
                for(String uniqueKeyField:uniqueKeyFieldList){
                    if(uniqueKeyField.startsWith(uniqueKey)){
                        String[] tokens = uniqueKeyField.split("\\|", -1);
                        String projectName = tokens[0];
                        String fieldName = tokens[3];
                        String comment = tokens[4];
                        String parameter = tokens.length>=6?tokens[5]:null;
                        if(!block.containsKey("operationFields")){
                            block.put("operationFields", new JSONObject(true));
                        }
                        JSONObject operationFields = block.getJSONObject("operationFields");
                        if(!operationFields.containsKey(fieldName)){
                            operationFields.put(fieldName, new JSONObject());
                        }
                        JSONObject operationField = operationFields.getJSONObject(fieldName);
                        setRemoteSelectOperation(projectName, comment, parameter, amsRemoteSelect.getString("type"), operationField);
                    }
                }
            }
        }
    }

    @Override
    public String name() {
        return "设置远程下拉框";
    }

    private void setRemoteSelectOperation(String projectName, String comment, String parameter, String type, JSONObject operationField){
        operationField.put("slot", "searchs");
        operationField.put("type", "field");
        operationField.put("label", comment);

        {
            JSONObject field = new JSONObject();
            field.put("BASE", "SELECT_REMOTE");
            field.put("type", "select");
            field.put("info", comment);
            {
                JSONObject props = new JSONObject();
                props.put("placeholder", "请选择"+comment);
                props.put("clearable", true);
                props.put("multiple", false);
                field.put("props", props);
            }
            {
                JSONObject remoteConfig = new JSONObject();
                remoteConfig.put("dataPath", "data");
                remoteConfig.put("action", "/ams/api/"+projectName+"/remoteSelect/"+type+(StringUtils.isNotBlank(parameter)?"?"+parameter:""));
                remoteConfig.put("queryKey", "name");
                remoteConfig.put("isCache", false);
                field.put("remoteConfig", remoteConfig);
            }
            operationField.put("field", field);
        }
    }
}
