package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.listener.operation.PropOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class SetAMSOperationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsOperationArray = (JSONArray) flowContext.getData("amsOperationArray", new JSONArray());
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsOperationArray.size();i++){
            JSONObject amsOperation = amsOperationArray.getJSONObject(i);

            for(int j=0;j<blocks.size();j++){
                JSONObject block = blocks.getJSONObject(j);

                if(!block.getString("projectName").equalsIgnoreCase(amsOperation.getString("projectName"))){
                    continue;
                }
                if(!block.getString("daoName").equalsIgnoreCase(amsOperation.getString("daoName"))){
                    continue;
                }
                if(!block.getString("tableName").equalsIgnoreCase(amsOperation.getString("tableName"))){
                    continue;
                }
                String methodName = amsOperation.getString("methodName");
                if(StringUtils.isBlank(methodName)){
                    continue;
                }
                String position = amsOperation.getString("position");
                if("None".equalsIgnoreCase(position)){
                    continue;
                }
                String name = amsOperation.getString("name");
                Validate.notEmpty(name, "名称不能为空!类名:"+amsOperation.getClass().getName());

                if(!block.containsKey("operationFields")){
                    block.put("operationFields", new JSONObject(true));
                }
                JSONObject operationFields = block.getJSONObject("operationFields");
                {
                    JSONObject operationField = new JSONObject();
                    setOperationField(operationField, amsOperation, true);
                    operationFields.put(methodName, operationField);
                }
                if("MultipleSelect".equalsIgnoreCase(position)){
                    JSONObject singleOperationField = new JSONObject();
                    setOperationField(singleOperationField, amsOperation, false);
                    operationFields.put("multipleSelect_"+methodName, singleOperationField);
                }
            }
        }
    }

    @Override
    public String name() {
        return "设置操作按钮";
    }

    private void setOperationField(JSONObject operationField, JSONObject amsOperation, boolean checkMultiple) throws Exception {
        String name = amsOperation.getString("name");
        String methodName = amsOperation.getString("methodName");
        String[] fieldNameList = (String[]) amsOperation.get("fieldNameList");
        String position = amsOperation.getString("position");

        operationField.put("type", "button");
        operationField.put("label", name);
        {
            JSONObject props = new JSONObject();
            props.put("type", "primary");
            if(amsOperation.containsKey("props")){
                PropOperation propOperation = (PropOperation) amsOperation.get("props");
                propOperation.props(props);
            }
            operationField.put("props", props);
        }
        String fieldNames = StringUtils.join(fieldNameList, ",");
        operationField.put("event", "confirm:确认"+name+"吗? sendRequest:"+methodName+(StringUtils.isNotBlank(fieldNames)?","+fieldNames:"")+" list:1");

        operationField.put("slot", "");
        if("RightTop".equalsIgnoreCase(position)){
            operationField.put("slot", "rightTop");
        }
        if(checkMultiple){
            if("MultipleSelect".equalsIgnoreCase(position)){
                operationField.put("slot", "multipleSelect");
                operationField.put("label", "批量"+name);
                operationField.put("event", "confirm:确认批量"+name+"吗? sendRequest:"+methodName+(StringUtils.isNotBlank(fieldNames)?","+fieldNames:"")+" list:1");
            }
        }
    }
}
