package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.listener.dialog.AddBlockItemDialogOption;
import cn.schoolwow.ams.domain.listener.dialog.EditBlockItemDialogOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class SetAMSDialogFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsDialogArray = (JSONArray) flowContext.getData("amsDialogArray", new JSONArray());

        if(null==amsDialogArray||amsDialogArray.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsDialogArray.size();i++){
            JSONObject amsDialog = amsDialogArray.getJSONObject(i);
            for(int j=0;j<blocks.size();j++){
                JSONObject block = blocks.getJSONObject(j);
                if(!amsDialog.getString("projectName").equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsDialog.getString("daoName").equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsDialog.getString("tableName").equals(block.getString("tableName"))){
                    continue;
                }

                JSONObject itemDialog = new JSONObject();
                setAddButton(amsDialog, block, itemDialog);
                setUpdateButton(amsDialog, block, itemDialog);
                setDeleteButton(amsDialog, block);
                block.put("itemDialog", itemDialog);
            }
        }
    }

    @Override
    public String name() {
        return "配置列表增删改按钮";
    }

    private void setAddButton(JSONObject amsDialog, JSONObject block, JSONObject itemDialog){
        if(!amsDialog.containsKey("addBlockItemDialogOption")){
            return;
        }
        AddBlockItemDialogOption addBlockItemDialogOption = (AddBlockItemDialogOption) amsDialog.get("addBlockItemDialogOption");

        String[] addFieldNameList = addBlockItemDialogOption.addFieldNameList;
        Validate.notEmpty(addFieldNameList, "待添加字段不能为空!涉及类名:"+amsDialog.getString("awareClassName"));

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("slot", "rightTop");
            operationField.put("label", "新增"+amsDialog.getString("name"));
            {
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                operationField.put("props", props);
            }
            operationField.put("event", "addBlockItemDialog list:1");
        }
        operationFields.put("addBlockItemDialogButton", operationField);

        itemDialog.put("addBlockItemDialogOption", addBlockItemDialogOption);
    }

    private void setUpdateButton(JSONObject amsDialog, JSONObject block, JSONObject itemDialog){
        if(!amsDialog.containsKey("editBlockItemDialogOption")){
            return;
        }
        EditBlockItemDialogOption editBlockItemDialogOption = (EditBlockItemDialogOption) amsDialog.get("editBlockItemDialogOption");

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("label", "更新");
            {
                JSONObject props = new JSONObject();
                props.put("type", "warning");
                operationField.put("props", props);
            }
            operationField.put("event", "editBlockItemDialog list:1");
        }
        operationFields.put("editShopSupplyItemDialogButton", operationField);

        itemDialog.put("editBlockItemDialogOption", editBlockItemDialogOption);
    }

    private void setDeleteButton(JSONObject amsDialog, JSONObject block){
        String deleteField = amsDialog.getString("deleteField");
        if(null==deleteField||deleteField.isEmpty()){
            return;
        }

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        //添加删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("type", "button");
            operationField.put("label", "删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("deleteButton", operationField);
        }
        //添加批量删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("slot", "multipleSelect");
            operationField.put("type", "button");
            operationField.put("label", "批量删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认批量删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("multipleDeleteButton", operationField);
        }
    }
}
