package cn.schoolwow.ams.flow.dispatcher.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class SetAMSTableListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsTableListenerArray = (JSONArray) flowContext.getData("amsTableListenerArray", new JSONArray());
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");

        if(null==amsTableListenerArray||amsTableListenerArray.isEmpty()){
            return;
        }
        for(int i=0;i<amsTableListenerArray.size();i++){
            JSONObject amsTableListener = amsTableListenerArray.getJSONObject(i);

            if(!projectName.equalsIgnoreCase(amsTableListener.getString("projectName"))){
                continue;
            }
            if(!daoName.equalsIgnoreCase(amsTableListener.getString("daoName"))){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsTableListener.getString("tableName"))){
                continue;
            }
            if(amsTableListener.containsKey("listTable")){
                flowContext.putTemporaryData("listTable", amsTableListener.get("listTable"));
            }
            if(amsTableListener.containsKey("createTable")){
                flowContext.putTemporaryData("createTable", amsTableListener.get("createTable"));
            }
            if(amsTableListener.containsKey("editTable")){
                flowContext.putTemporaryData("editTable", amsTableListener.get("editTable"));
            }
            if(amsTableListener.containsKey("deleteTable")){
                flowContext.putTemporaryData("deleteTable", amsTableListener.get("deleteTable"));
            }
            break;
        }
    }

    @Override
    public String name() {
        return "根据数据库名设置amsTableListener";
    }
}
