package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.domain.listener.clazz.CreateClazzListener;
import cn.schoolwow.ams.domain.listener.table.CreateTable;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Set;

public class CreateFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "create操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject createEntity = (JSONObject) flowContext.checkData("createEntity");
        AMSListener amsListener = (AMSListener) flowContext.checkData("amsListener");
        CreateTable createTable = (CreateTable) flowContext.getData("createTable");

        if(null!=createTable){
            createTable.beforeCreate(createEntity);
        }
        DAO dao = amsListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if(null==entity){
            Set<String> keySet = createEntity.keySet();
            for(String key:keySet){
                Object value = createEntity.get(key);
                createEntity.put(StringUtil.camel2Underline(key), value);
                createEntity.remove(key);
            }
            dao.insert(tableName, createEntity);
        }else{
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
        if(null!=createTable){
            createTable.afterCreate(createEntity);
        }
    }

    private void getByClazz(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject createEntity = (JSONObject) flowContext.checkData("createEntity");
        JSONArray amsClazzListenerArray = (JSONArray) flowContext.getData("amsClazzListenerArray", new JSONArray());

        for(int i=0;i<amsClazzListenerArray.size();i++){
            JSONObject o = amsClazzListenerArray.getJSONObject(i);

            if(!o.containsKey("create")){
                continue;
            }
            if(!projectName.equalsIgnoreCase(o.getString("projectName"))){
                continue;
            }
            if(!tableName.equalsIgnoreCase(o.getString("className"))){
                continue;
            }
            CreateClazzListener createClazzListener = (CreateClazzListener) o.get("create");
            createClazzListener.create(createEntity);
            return;
        }
        throw new IllegalArgumentException("未匹配到Clazz选项!方法:Create,项目名:"+projectName+",类型:"+tableName);
    }
}
