package cn.schoolwow.ams.config;

import cn.schoolwow.ams.flow.composite.SetAMSInfoCompositeBusiness;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONArray;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

@Configuration
@ComponentScan(basePackages = "cn.schoolwow.ams")
public class AMSConfig {
    @Bean
    public QuickFlow amsFlow(ApplicationContext applicationContext){
        QuickFlow amsFlow = QuickFlow.newInstance()
                .putContextData("blocks", new JSONArray())
                .putContextData("scriptPathList", new ArrayList<>())
                .putContextData("amsListenerList", applicationContext.getBeansOfType(AMSListener.class).values());
        //初始化
        amsFlow.executeFlow(applicationContext.getBean(SetAMSInfoCompositeBusiness.class));
        return amsFlow;
    }
}
