package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class SetScriptPathFlow implements BusinessFlow {
    @Autowired
    private List<AMSListListener> amsListListenerList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());

        for(AMSListListener amsListListener:amsListListenerList){
            scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("/ams/"+amsListListener.projectName(),"static/ams/"+amsListListener.projectName()));
            scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("/ams/commonOperation","static/ams/commonOperation"));
            amsListListener.initialScriptPath(scriptPathList);
        }
    }

    @Override
    public String name() {
        return "设置加载脚本路径";
    }

}
