package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSOperationFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSOperation> amsOperationList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==amsOperationList||amsOperationList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(AMSOperation amsOperation:amsOperationList){
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                if(!amsOperation.projectName().equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsOperation.daoName().equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsOperation.tableName().equals(block.getString("tableName"))){
                    continue;
                }
                String methodName = amsOperation.methodName();
                if(StringUtils.isBlank(methodName)){
                    continue;
                }
                if(methodName.endsWith("Ignore")){
                    continue;
                }
                String name = amsOperation.name();
                Validate.notEmpty(name, "名称不能为空!类名:"+amsOperation.getClass().getName());

                if(!block.containsKey("operationFields")){
                    block.put("operationFields", new JSONObject(true));
                }
                JSONObject operationFields = block.getJSONObject("operationFields");
                {
                    JSONObject operationField = new JSONObject();
                    setOperationField(operationField, amsOperation, true);
                    operationFields.put(amsOperation.methodName(), operationField);
                }
                if(amsOperation.methodName().startsWith("multiple")){
                    JSONObject singleOperationField = new JSONObject();
                    setOperationField(singleOperationField, amsOperation, false);
                    operationFields.put("row_"+amsOperation.methodName(), singleOperationField);
                }
            }
        }
    }

    @Override
    public String name() {
        return "设置操作按钮";
    }

    private void setOperationField(JSONObject operationField, AMSOperation amsOperation, boolean checkMultiple){
        operationField.put("type", "button");
        operationField.put("label", amsOperation.name());
        {
            JSONObject props = new JSONObject();
            props.put("type", "primary");
            amsOperation.props(props);
            operationField.put("props", props);
        }
        String fieldNames = StringUtils.join(amsOperation.fieldNameList(), ",");
        operationField.put("event", "confirm:确认"+amsOperation.name()+"吗? sendRequest:"+amsOperation.methodName()+(StringUtils.isNotBlank(fieldNames)?","+fieldNames:"")+" list:1");

        operationField.put("slot", "");
        if(amsOperation.methodName().endsWith("RightTop")){
            operationField.put("slot", "rightTop");
        }
        if(checkMultiple){
            if(amsOperation.methodName().startsWith("multiple")){
                operationField.put("slot", "multipleSelect");
                operationField.put("label", "批量"+amsOperation.name());
                operationField.put("event", "confirm:确认批量"+amsOperation.name()+"吗? sendRequest:"+amsOperation.methodName()+(StringUtils.isNotBlank(fieldNames)?","+fieldNames:"")+" list:1");
            }
        }
    }
}
