package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.domain.BeforeEditOption;
import cn.schoolwow.ams.listener.AMSClazzListener;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dml.DatabaseManipulation;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class EditFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "edit操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject updateEntity = (JSONObject) flowContext.checkData("updateEntity");
        AMSListListener amsListListener = (AMSListListener) flowContext.checkData("amsListListener");
        AMSTableListener amsTableListener = (AMSTableListener) flowContext.getData("amsTableListener");

        BeforeEditOption beforeEditOption = null;
        if(null!=amsTableListener){
            beforeEditOption = amsTableListener.beforeEdit(updateEntity);
        }
        if(null==beforeEditOption){
            beforeEditOption = new BeforeEditOption();
        }

        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if(null==entity){
            Validate.isTrue(null!=beforeEditOption.uniqueFieldNameArray&&beforeEditOption.uniqueFieldNameArray.length>0, "jsonObject格式更新,必须制定唯一字段名称列表!");
            Set<String> keySet = updateEntity.keySet();
            for(String key:keySet){
                Object value = updateEntity.get(key);
                updateEntity.put(StringUtil.camel2Underline(key), value);
                updateEntity.remove(key);
            }
            DatabaseManipulation dml = dao.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            if(null!=beforeEditOption.partColumnArray&&beforeEditOption.partColumnArray.length>0){
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            dml.updateType(beforeEditOption.updateType).update(tableName, updateEntity);
        }else{
            DatabaseManipulation dml = dao.updateType(UpdateType.UpdateByUniqueKey);
            if(null!=beforeEditOption.partColumnArray&&beforeEditOption.partColumnArray.length>0){
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            if(null!=beforeEditOption.uniqueFieldNameArray&&beforeEditOption.uniqueFieldNameArray.length>0){
                dml.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            }
            Object updateInstance = updateEntity.toJavaObject(entity.clazz);
            dml.updateType(beforeEditOption.updateType).update(updateInstance);
        }
        if(null!=amsTableListener){
            amsTableListener.afterEdit(beforeEditOption, updateEntity);
        }
    }

    private void getByClazz(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject updateEntity = (JSONObject) flowContext.checkData("updateEntity");
        Collection<AMSClazzListener> amsClazzListeners = (Collection<AMSClazzListener>) flowContext.getData("amsClazzListenerList", Collections.emptyList());

        for(AMSClazzListener amsClazzListener:amsClazzListeners){
            if(!amsClazzListener.className().equalsIgnoreCase(tableName)){
                continue;
            }
            amsClazzListener.edit(updateEntity);
            return;
        }
        throw new IllegalArgumentException("未匹配到Clazz选项!方法:Edit,项目名:"+projectName+",类型:"+tableName);
    }
}
