package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.listener.AMSClazzListener;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class DeleteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "delete操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        AMSListListener amsListListener = (AMSListListener) flowContext.checkData("amsListListener");
        AMSTableListener amsTableListener = (AMSTableListener) flowContext.getData("amsTableListener");

        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = null;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        }else{
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);

        if(null!=amsTableListener){
            amsTableListener.beforeDelete(condition, amsListCondition);
        }
        condition.clone().execute().delete();
        if(null!=amsTableListener){
            amsTableListener.afterDelete(condition, amsListCondition);
        }
    }

    private void getByClazz(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        Collection<AMSClazzListener> amsClazzListeners = (Collection<AMSClazzListener>) flowContext.getData("amsClazzListenerList", Collections.emptyList());

        for(AMSClazzListener amsClazzListener:amsClazzListeners){
            if(!amsClazzListener.className().equalsIgnoreCase(tableName)){
                continue;
            }
            amsClazzListener.delete(amsListConditionMap);
            return;
        }
        throw new IllegalArgumentException("未匹配到Clazz选项!方法:Delete,项目名:"+projectName+",类型:"+tableName);
    }
}
