package cn.schoolwow.ams.flow.block.common;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Field;

public class GetResourceFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setComment(flowContext);
        String comment = (String) flowContext.checkData("comment");
        if(comment.contains("(")){
            setSelectField(flowContext);
        }else{
            setBasicField(flowContext);
        }
    }

    @Override
    public String name() {
        return "获取Resource对象对象";
    }

    private void setComment(FlowContext flowContext){
        if(flowContext.containKey("entityField")){
            Field entityField = (Field) flowContext.checkData("entityField");
            Comment commentAnnotation = entityField.getAnnotation(Comment.class);
            String comment = null==commentAnnotation?entityField.getName():commentAnnotation.value();
            flowContext.putCurrentFlowData("comment", comment);
        }else if(flowContext.containKey("property")){
            Property property = (Property) flowContext.checkData("property");
            flowContext.putCurrentFlowData("comment", property.comment);
        }else{
            throw new IllegalArgumentException("entityField和property字段值不能都为空");
        }
    }

    private void setSelectField(FlowContext flowContext){
        String comment = (String) flowContext.checkData("comment");

        JSONObject field = new JSONObject();
        String fieldComment = comment.substring(0, comment.indexOf("("));
        field.put("label", fieldComment);
        field.put("info", "请选择" + fieldComment);
        field.put("type", "select");

        JSONObject props = new JSONObject();
        field.put("props", props);
        props.put("placeholder", "请选择" + fieldComment);
        props.put("clearable", true);
        props.put("multiple", false);

        JSONObject options = new JSONObject();
        props.put("options", options);

        String selectText = comment.substring(comment.indexOf("(") + 1, comment.indexOf(")"));
        String[] tokens = selectText.split(",");
        for (String token : tokens) {
            int indexOf = token.indexOf(":");
            if (indexOf < 0) {
                throw new IllegalArgumentException("注释异常,非标准下拉框格式!注释:" + comment);
            }
            String key = token.substring(0, indexOf);
            String value = token.substring(indexOf + 1);
            options.put(key, value + "(" + key + ")");
        }
        flowContext.putTemporaryData("resourceField", field);
    }

    private void setBasicField(FlowContext flowContext){
        String comment = (String) flowContext.checkData("comment");

        JSONObject field = new JSONObject();
        field.put("label", comment);
        field.put("info", "请输入" + comment);

        if(flowContext.containKey("entityField")){
            Field entityField = (Field) flowContext.checkData("entityField");
            switch (entityField.getType().getName()) {
                case "java.util.Date":
                case "java.sql.LocalDate":{
                    field.put("type", "date");
                }break;
                case "java.sql.Timestamp":
                case "java.sql.LocalDateTime": {
                    field.put("type", "datetime");
                }break;
                case "com.alibaba.fastjson.JSONObject":
                case "com.alibaba.fastjson.JSONArray":{
                    field.put("type", "textarea");
                }break;
                default: {
                    field.put("type", "text");
                }
            }
        }else if(flowContext.containKey("property")){
            Property property = (Property) flowContext.checkData("property");
            if (property.columnType.contains("date") || property.columnType.contains("timestamp")) {
                field.put("type", "datetime");
            } else if(property.comment.startsWith("是否")){
                field.put("type", "switch");
            }else if(property.column.contains("url")){
                field.put("type", "link");
            }else{
                field.put("type", "text");
            }
        }else{
            throw new IllegalArgumentException("entityField和property字段值不能都为空");
        }

        JSONObject props = new JSONObject();
        props.put("placeholder", "请输入" + comment);
        field.put("props", props);

        flowContext.putTemporaryData("resourceField", field);
    }
}
