package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSGlobalConfig;
import cn.schoolwow.ams.listener.AMSListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

@ControllerAdvice
public class AMSExceptionHandler {

    @Autowired(required = false)
    private AMSGlobalConfig amsGlobalConfig;

    @Resource
    private List<AMSListener> amsListenerList;

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        if(null!=amsGlobalConfig){
            amsGlobalConfig.beforePrintError(ex);
        }else if(amsListenerList.size()==1){
            amsListenerList.get(0).beforePrintError(ex);
        }else{
            throw new IllegalArgumentException("未配置AMSGlobalConfig对象或者ams项目大于1个!ams项目个数:"+amsListenerList.size());
        }
        return new AMSResult(ex.getMessage());
    }

}
