package cn.schoolwow.ams.flow.dispatcher.common;

import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;

public class SetAMSTableListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Collection<AMSTableListener> amsTableListenerList = (Collection<AMSTableListener>) flowContext.getData("amsTableListenerList");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");

        if(null==amsTableListenerList){
            return;
        }
        for(AMSTableListener amsTableListener:amsTableListenerList){
            if(amsTableListener.daoName().equals(daoName)
                    &&amsTableListener.tableName().equals(tableName)){
                flowContext.putTemporaryData("amsTableListener", amsTableListener);
                break;
            }
        }
    }

    @Override
    public String name() {
        return "根据数据库名设置amsTableListener";
    }
}
