package cn.schoolwow.ams.config;

import cn.schoolwow.ams.flow.composite.SetAMSInfoCompositeBusiness;
import cn.schoolwow.ams.listener.*;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.service.DefaultAMSDispatcherService;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONArray;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

@Configuration
@ComponentScan(basePackages = "cn.schoolwow.ams")
public class AMSConfig {
    @Bean
    public QuickFlow amsFlow(ApplicationContext applicationContext){
        QuickFlow amsFlow = QuickFlow.newInstance()
                .putContextData("blocks", new JSONArray())
                .putContextData("scriptPathList", new ArrayList<>())
                .putContextData("amsListListenerList", applicationContext.getBeansOfType(AMSListListener.class).values())
                .putContextData("amsTableListenerList", applicationContext.getBeansOfType(AMSTableListener.class).values())
                .putContextData("amsClazzListenerList", applicationContext.getBeansOfType(AMSClazzListener.class).values())
                .putContextData("amsOperationList", applicationContext.getBeansOfType(AMSOperation.class).values())
                .putContextData("amsRemoteSelectList", applicationContext.getBeansOfType(AMSRemoteSelect.class).values());
        try {
            AMSDispatcherService amsDispatcherService = (AMSDispatcherService) applicationContext.getBean("amsDispatcherService");
            amsFlow.putContextData("amsDispatcherService", amsDispatcherService);
        }catch (NoSuchBeanDefinitionException e){
            AMSDispatcherService amsDispatcherService = new DefaultAMSDispatcherService(amsFlow);
            amsFlow.putContextData("amsDispatcherService", amsDispatcherService);
        }
        //初始化
        amsFlow.executeFlow(applicationContext.getBean(SetAMSInfoCompositeBusiness.class));
        return amsFlow;
    }
}
