/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.util;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class AMSUtil {
    private static Logger logger = LoggerFactory.getLogger(AMSUtil.class);

    public static List<String> getJavascriptResourcePathList(final String prefix, String path) throws IOException {
        ClassPathResource resource = new ClassPathResource(path);
        if (!resource.exists()) {
            return new ArrayList<String>();
        }
        URL url = resource.getURI().toURL();
        final ArrayList<String> resourcePathList = new ArrayList<String>();
        switch (url.getProtocol()) {
            case "file": {
                final File directory = new File(url.getFile());
                Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        File file = path.toFile();
                        if (file.getName().endsWith(".js")) {
                            String relativePath = file.getAbsolutePath().replace(directory.getAbsolutePath(), "").replace("\\", "/");
                            resourcePathList.add(prefix + relativePath);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            case "jar": {
                JarFile jarFile;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.startsWith("static") || !jarEntryName.contains(path) || !jarEntryName.endsWith(".js")) continue;
                    resourcePathList.add(jarEntryName.substring(jarEntryName.indexOf("/")));
                }
                break;
            }
        }
        return resourcePathList;
    }

    public static Condition pageAndSort(Condition condition, JSONObject amsListCondition) {
        int page = amsListCondition.containsKey((Object)"page") ? amsListCondition.getInteger("page") : 1;
        int pageSize = amsListCondition.containsKey((Object)"pageSize") ? amsListCondition.getInteger("pageSize") : 10;
        condition.page(page, pageSize);
        String sortField = amsListCondition.getString("sortField");
        String sortOrder = amsListCondition.getString("sortOrder");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sortField}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sortOrder})) {
            condition.order(sortField, sortOrder);
        }
        amsListCondition.remove((Object)"page");
        amsListCondition.remove((Object)"pageSize");
        amsListCondition.remove((Object)"sortField");
        amsListCondition.remove((Object)"sortOrder");
        return condition;
    }

    public static void addCompositeQuery(Entity entity, Condition condition, JSONObject amsListCondition) {
        Set keySet = amsListCondition.keySet();
        for (String key : keySet) {
            Property property = entity.getPropertyByFieldNameOrColumnName(key);
            if (null == property) {
                property = entity.getPropertyByFieldNameOrColumnName(StringUtil.camel2Underline((String)key));
            }
            if (null == property) continue;
            String value = amsListCondition.getString(key);
            condition.addCompositeQuery(key, value);
        }
    }

    public static JSONObject getAMSList(Collection list) {
        JSONObject amsList = new JSONObject();
        amsList.put("list", (Object)list);
        return amsList;
    }

    public static JSONObject getAMSPagingList(PageVo pageVo) {
        JSONObject amsList = new JSONObject();
        amsList.put("list", (Object)pageVo.getArray());
        amsList.put("total", (Object)pageVo.getTotalSize());
        return amsList;
    }
}

