/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.flow.initial.GetConfigFlow;
import cn.schoolwow.ams.flow.initial.RefreshExtraDataFlow;
import cn.schoolwow.ams.listener.AMSGlobalConfig;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController {
    @Resource
    private QuickFlow amsFlow;
    @Resource
    private AMSGlobalConfig amsGlobalConfig;
    @Resource
    private ApplicationContext applicationContext;

    @RequestMapping(value={"/config"})
    public JSONObject config(@RequestParam(value="projectName", required=false) String projectName) {
        if (null == projectName || projectName.isEmpty()) {
            projectName = this.amsGlobalConfig.defaultProjectName();
        }
        FlowContext flowContext = this.amsFlow.startFlow((BusinessFlow)this.applicationContext.getBean(GetConfigFlow.class)).putCurrentCompositeFlowData("projectName", (Object)projectName).execute();
        JSONObject config = (JSONObject)flowContext.checkData("config");
        return config;
    }

    @RequestMapping(value={"/refreshExtraData"})
    public JSONObject refreshExtraData(@RequestParam(value="projectName", required=false) String projectName) {
        if (null == projectName || projectName.isEmpty()) {
            projectName = this.amsGlobalConfig.defaultProjectName();
        }
        FlowContext flowContext = this.amsFlow.startFlow((BusinessFlow)this.applicationContext.getBean(RefreshExtraDataFlow.class)).putCurrentCompositeFlowData("projectName", (Object)projectName).execute();
        JSONObject extraData = (JSONObject)flowContext.getData("extraData");
        return extraData;
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.create(projectName, daoName, tableName, createEntity);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject updateEntity) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/{methodName}"})
    public JSONObject operationDispatcher(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
    }

    @RequestMapping(value={"/api/{projectName}/remoteSelect/{type}"})
    public JSONArray remoteSelect(@PathVariable(value="projectName") String projectName, @PathVariable(value="type") String type, @RequestParam(required=false) Map<String, String> amsRemoteSelectMap) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService)this.amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
    }
}

