package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSGlobalConfig;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

@ControllerAdvice
public class AMSExceptionHandler {

    @Resource
    private AMSGlobalConfig amsGlobalConfig;

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        amsGlobalConfig.beforePrintError(ex);
        return new AMSResult(ex.getMessage());
    }

}
