package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.AddBlockItemDialogOption;
import cn.schoolwow.ams.domain.EditBlockItemDialogOption;
import cn.schoolwow.ams.listener.AMSTableLConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSTableConfigFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSTableLConfig> amsTableLConfigList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==amsTableLConfigList||amsTableLConfigList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(AMSTableLConfig amsTableLConfig:amsTableLConfigList){
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                if(!amsTableLConfig.projectName().equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsTableLConfig.daoName().equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsTableLConfig.tableName().equals(block.getString("tableName"))){
                    continue;
                }
                Validate.notEmpty(amsTableLConfig.name(), "按钮名称不能为空!类名:"+amsTableLConfig.getClass().getName());

                JSONObject itemDialog = new JSONObject();
                if(setAddButton(amsTableLConfig, block)){
                    itemDialog.put("addBlockItemDialogOption", amsTableLConfig.getAddBlockItemDialogOption());
                }
                if(setUpdateButton(amsTableLConfig, block)){
                    itemDialog.put("editBlockItemDialogOption", amsTableLConfig.getEditBlockItemDialogOption());
                }
                setDeleteButton(amsTableLConfig, block);
                block.put("itemDialog", itemDialog);
            }
        }
    }

    @Override
    public String name() {
        return "配置列表增删改按钮";
    }

    private boolean setAddButton(AMSTableLConfig amsTableLConfig, JSONObject block){
        AddBlockItemDialogOption addBlockItemDialogOption = amsTableLConfig.getAddBlockItemDialogOption();
        if(null==addBlockItemDialogOption){
            return false;
        }
        String[] addFieldNameList = addBlockItemDialogOption.addFieldNameList;
        Validate.notEmpty(addFieldNameList, "待添加字段不能为空!类名:"+amsTableLConfig.getClass().getName());

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("slot", "rightTop");
            operationField.put("label", "新增"+amsTableLConfig.name());
            {
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                operationField.put("props", props);
            }
            operationField.put("event", "addBlockItemDialog");
        }
        operationFields.put("addBlockItemDialogButton", operationField);
        return true;
    }

    private boolean setUpdateButton(AMSTableLConfig amsTableLConfig, JSONObject block){
        EditBlockItemDialogOption editBlockItemDialogOption = amsTableLConfig.getEditBlockItemDialogOption();
        if(null==editBlockItemDialogOption){
            return false;
        }

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("label", "更新");
            {
                JSONObject props = new JSONObject();
                props.put("type", "warning");
                operationField.put("props", props);
            }
            operationField.put("event", "editBlockItemDialog");
        }
        operationFields.put("editShopSupplyItemDialogButton", operationField);
        return true;
    }

    private void setDeleteButton(AMSTableLConfig amsTableLConfig, JSONObject block){
        String deleteField = amsTableLConfig.getDeleteField();
        if(null==deleteField||deleteField.isEmpty()){
            return;
        }

        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        //添加删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("type", "button");
            operationField.put("label", "删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("deleteButton", operationField);
        }
        //添加批量删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("slot", "multipleSelect");
            operationField.put("type", "button");
            operationField.put("label", "批量删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认批量删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("multipleDeleteButton", operationField);
        }
    }
}
