package cn.schoolwow.ams.flow.block;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

@Service
public class AddClassBlockFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject block = (JSONObject) flowContext.checkData("block");
        String tableName = (String) flowContext.checkData("tableName");

        block.put("daoName", "clazz");
        block.put("tableName", tableName);
        setRequestField(flowContext);
        setResponseField(flowContext);
    }

    @Override
    public String name() {
        return "添加pojo类区块";
    }

    private void setRequestField(FlowContext flowContext){
        JSONObject block = (JSONObject) flowContext.checkData("block");
        Class requestClass = (Class) flowContext.checkData("requestClass");

        JSONObject fieldMap = new JSONObject(true);
        if(null!=requestClass){
            Field[] entityFields = requestClass.getDeclaredFields();
            Field.setAccessible(entityFields, true);
            for (Field entityField : entityFields) {
                if(Modifier.isTransient(entityField.getModifiers())){
                    continue;
                }
                if(null!=entityField.getAnnotation(Ignore.class)){
                    continue;
                }
                JSONObject field = getAMSField(requestClass, entityField);
                JSONObject operation = new JSONObject();
                operation.put("slot", "searchs");
                operation.put("type", "field");
                operation.put("label", field.getString("label"));
                operation.put("field", field);
                operation.put("info", field.getString("info"));
                fieldMap.put(entityField.getName(), operation);
            }
        }
        block.put("operationFields", fieldMap);
    }

    private void setResponseField(FlowContext flowContext){
        JSONObject block = (JSONObject) flowContext.checkData("block");
        Class responseClass = (Class) flowContext.checkData("responseClass");

        JSONObject fieldMap = new JSONObject(true);
        Field[] entityFields = responseClass.getDeclaredFields();
        Field.setAccessible(entityFields, true);
        for (Field entityField : entityFields) {
            if(Modifier.isTransient(entityField.getModifiers())){
                continue;
            }
            if(null!=entityField.getAnnotation(Ignore.class)){
                continue;
            }
            JSONObject field = getAMSField(responseClass, entityField);
            fieldMap.put(entityField.getName(), field);
        }
        block.put("resourceFields", fieldMap);
    }

    private JSONObject getAMSField(Class clazz, Field entityField){
        JSONObject field = new JSONObject();
        Comment commentAnnotation = entityField.getAnnotation(Comment.class);
        String comment = null==commentAnnotation?entityField.getName():commentAnnotation.value();
        //判断是否下拉选择
        if (comment.contains("(")) {
            String fieldComment = comment.substring(0, comment.indexOf("("));
            field.put("label", fieldComment);
            field.put("info", "请选择" + fieldComment);
            field.put("type", "select");

            JSONObject props = new JSONObject();
            field.put("props", props);
            props.put("placeholder", "请选择" + fieldComment);
            props.put("clearable", true);
            props.put("multiple", false);

            JSONObject options = new JSONObject();
            props.put("options", options);

            String selectText = comment.substring(comment.indexOf("(") + 1, comment.indexOf(")"));
            String[] tokens = selectText.split(",");
            for (String token : tokens) {
                int indexOf = token.indexOf(":");
                if (indexOf < 0) {
                    throw new IllegalArgumentException("实体类注释异常!类名:" + clazz.getName() + ",字段名:" + entityField.getName() + ",注释:" + comment);
                }
                String key = token.substring(0, indexOf);
                String value = token.substring(indexOf + 1);
                options.put(key, value + "(" + key + ")");
            }
        } else {
            field.put("label", comment);
            field.put("info", "请输入" + comment);

            switch (entityField.getType().getName()) {
                case "java.util.Date":{
                    field.put("type", "date");
                }break;
                case "java.sql.Timestamp":
                case "java.sql.LocalDate":
                case "java.sql.LocalDateTime": {
                    field.put("type", "datetime");
                }
                break;
                default: {
                    field.put("type", "text");
                }
            }
            JSONObject props = new JSONObject();
            field.put("props", props);
            props.put("placeholder", "请输入" + comment);
        }
        return field;
    }
}
