package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.CopyFieldOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetCopyFieldOperationFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<CopyFieldOperation> copyFieldOperationList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==copyFieldOperationList||copyFieldOperationList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(CopyFieldOperation copyFieldOperation:copyFieldOperationList){
            String[] copyFieldArray = copyFieldOperation.copyFieldArray();
            Validate.notEmpty(copyFieldArray, "待复制字段不能为空!类名:"+copyFieldOperation.getClass().getName());

            for(String copyField:copyFieldArray){
                String[] tokens = copyField.split("\\|", -1);
                String projectName = tokens[0];
                String daoName = tokens[1];
                String tableName = tokens[2];
                String fieldName = tokens[3];
                String comment = tokens[4];
                Validate.notEmpty(fieldName, "待复制字段不能为空!类名:"+copyFieldOperation.getClass().getName());
                Validate.notEmpty(comment, "复制按钮名称不能为空!类名:"+copyFieldOperation.getClass().getName());

                for(int i=0;i<blocks.size();i++) {
                    JSONObject block = blocks.getJSONObject(i);
                    if(!projectName.equals(block.getString("projectName"))){
                        continue;
                    }
                    if(!daoName.equals(block.getString("daoName"))){
                        continue;
                    }
                    if(!tableName.equals(block.getString("tableName"))){
                        continue;
                    }

                    if(!block.containsKey("operationFields")){
                        block.put("operationFields", new JSONObject(true));
                    }
                    JSONObject operationFields = block.getJSONObject("operationFields");
                    JSONObject operationField = new JSONObject();
                    {
                        operationField.put("type", "button");
                        operationField.put("label", comment);
                        {
                            JSONObject props = new JSONObject();
                            props.put("type", "primary");
                            operationField.put("props", props);
                        }
                        operationField.put("event", "copyField:"+fieldName);
                    }
                    operationFields.put("copy|"+fieldName.replace(",","|"), operationField);
                }
            }
        }
    }

    @Override
    public String name() {
        return "设置复制字段按钮";
    }

}
