package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.flow.controller.GetConfigFlow;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@RequestMapping("/ams")
public class AMSController {
    @Resource
    private QuickFlow amsFlow;

    @Resource
    private ApplicationContext applicationContext;

    @RequestMapping("/config")
    public JSONObject config() {
        FlowContext flowContext = amsFlow.executeFlow(applicationContext.getBean(GetConfigFlow.class));
        JSONObject config = (JSONObject) flowContext.checkData("config");
        return config;
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/list")
    public JSONObject list(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/create")
    public void create(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject createEntity
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.create(projectName, daoName, tableName, createEntity);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/edit")
    public void edit(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject updateEntity
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/delete")
    public void delete(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/{methodName}")
    public JSONObject operationDispatcher(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @PathVariable("methodName") String methodName,
            @RequestBody(required = false) JSONObject requestBody
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
    }

    @RequestMapping("/api/{projectName}/remoteSelect/{type}")
    public JSONArray remoteSelect(
            @PathVariable("projectName") String projectName,
            @PathVariable("type") String type,
            @RequestParam(required = false) Map<String, String> amsRemoteSelectMap
    ) throws Exception {
        AMSDispatcherService amsDispatcherService = (AMSDispatcherService) amsFlow.getContextData("amsDispatcherService");
        return amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
    }

}
