package cn.schoolwow.ams.block;

import cn.schoolwow.ams.flow.block.AddClassBlockFlow;
import cn.schoolwow.ams.flow.block.AddDatabaseEntityBlockFlow;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;

public class BlockBuilder {
    private JSONObject block = new JSONObject();
    {
        block.put("id", "id");
        block.put("initList", true);
        block.put("blockConfig", new JSONObject());
    }

    public static BlockBuilder newInstance(){
        return new BlockBuilder();
    }

    /**指定项目名*/
    public BlockBuilder projectName(String projectName){
        block.put("projectName", projectName);
        return this;
    }

    /**添加数据库区块*/
    public BlockBuilder databaseBlock(String daoName, Entity entity){
        QuickFlow.defaultQuickFlow().startFlow(new AddDatabaseEntityBlockFlow())
                .putCurrentCompositeFlowData("block", block)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entity", entity)
                .execute();
        return this;
    }

    /**添加实体类区块*/
    public BlockBuilder classBlock(Class clazz){
        return classBlock(clazz.getSimpleName(), clazz, clazz);
    }

    /**添加实体类区块*/
    public BlockBuilder classBlock(String tableName, Class requestClass, Class responseClass){
        QuickFlow.defaultQuickFlow().startFlow(new AddClassBlockFlow())
                .putCurrentCompositeFlowData("block", block)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("requestClass", requestClass)
                .putCurrentCompositeFlowData("responseClass", responseClass)
                .execute();
        return this;
    }

    /**指定主键*/
    public BlockBuilder idField(String idField){
        block.put("id", idField);
        return this;
    }

    /**是否初始化*/
    public BlockBuilder initList(boolean initList){
        block.put("initList", initList);
        return this;
    }

    /**前端分页*/
    public BlockBuilder simulate(){
        JSONObject blockConfig = block.getJSONObject("blockConfig");
        blockConfig.put("pageSize", 10);
        JSONObject props = new JSONObject();
        props.put("pagination", "simulate");
        blockConfig.put("props", props);
        return this;
    }

    /**额外属性,会覆盖默认list配置*/
    public BlockBuilder blockConfig(JSONObject blockConfig){
        block.put("blockConfig", blockConfig);
        return this;
    }


    public JSONObject getBlock(){
        return block;
    }

}
