/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController {
    @Value(value="${spring.profiles.active}")
    private String activeProfile;
    @Resource
    private AMSListener amsListener;
    @Resource
    private AMSListListener amsListListener;
    @Resource
    private List<AMSOperation> amsOperationList;
    private JSONArray blocks = new JSONArray();
    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() throws IOException {
        this.amsListListener.initialBlocks(this.blocks);
        this.scriptPathList.add("router.js");
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/operation"));
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/page"));
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
    }

    @RequestMapping(value={"/config"})
    public JSONObject config() throws IOException {
        if (!"docker".equals(this.activeProfile)) {
            this.blocks.clear();
            this.scriptPathList.clear();
            this.postConstruct();
        }
        JSONObject config = new JSONObject();
        config.put("applicationName", (Object)this.amsListener.applicationName());
        config.put("blocks", (Object)this.blocks);
        config.put("scriptPathList", this.scriptPathList);
        return config;
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) {
        Condition condition;
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for (Property property : entity.properties) {
                condition.addColumn(new String[]{property.column + " " + StringUtil.underline2Camel((String)property.column)});
            }
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        this.amsListListener.beforeExecuteCondition(daoName, tableName, condition, amsListCondition);
        PageVo pageVo = condition.execute().getPagingList();
        this.amsListListener.afterExecuteCondition(daoName, tableName, pageVo);
        return AMSUtil.getAMSPagingList(pageVo);
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) {
        this.amsListListener.beforeCreate(daoName, tableName, createEntity);
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            Set keySet = createEntity.keySet();
            for (String key : keySet) {
                Object value = createEntity.get((Object)key);
                createEntity.put(StringUtil.camel2Underline((String)key), value);
                createEntity.remove((Object)key);
            }
            dao.insert(tableName, createEntity);
        } else {
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam(name="uniqueFieldNames", required=false, defaultValue="") String uniqueFieldNames, @RequestBody JSONObject updateEntity) {
        this.amsListListener.beforeEdit(daoName, tableName, updateEntity);
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            Validate.notEmpty((CharSequence)uniqueFieldNames, (String)"jsonObject\u683c\u5f0f\u63d2\u5165,\u5fc5\u987b\u5236\u5b9a\u552f\u4e00\u5b57\u6bb5\u540d\u79f0\u5217\u8868!", (Object[])new Object[0]);
            Set keySet = updateEntity.keySet();
            for (String key : keySet) {
                Object value = updateEntity.get((Object)key);
                updateEntity.put(StringUtil.camel2Underline((String)key), value);
                updateEntity.remove((Object)key);
            }
            dao.partColumn(uniqueFieldNames.split(",", -1)).update(tableName, updateEntity);
        } else if (uniqueFieldNames.isEmpty()) {
            Object instance = updateEntity.toJavaObject(entity.clazz);
            dao.update(instance);
        } else {
            dao.partColumn(uniqueFieldNames.split(",", -1)).update(tableName, updateEntity);
        }
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) {
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        this.amsListListener.beforeDelete(daoName, tableName, amsListCondition);
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = null;
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        this.amsListListener.beforeExecuteCondition(daoName, tableName, condition, amsListCondition);
        condition.execute().delete();
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/{methodName}"})
    public JSONObject dispatcherRequest(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        for (AMSOperation amsOperation : this.amsOperationList) {
            if (!daoName.equalsIgnoreCase(amsOperation.daoName()) || !tableName.equalsIgnoreCase(amsOperation.tableName()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{amsOperation.methodName()}) && !methodName.equalsIgnoreCase(amsOperation.methodName())) continue;
            return amsOperation.handle(methodName, requestBody);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!dao:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
    }
}

