userBlockMap["log@http_request_log"] = {
    "operations": {
        "execute": {
            "type": "button",
            "label": "重新执行",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认重新执行吗? execute"
        },
        "copyRequestBody": {
            "type": "button",
            "label": "复制请求体",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "show": function(row){
                return row.hasOwnProperty("requestBody");
            },
            "event": "copyRequestBody"
        },
        "copyResponseBody": {
            "type": "button",
            "label": "复制响应体",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "show": function(row){
                return row.hasOwnProperty("responseBody");
            },
            "event": "copyResponseBody"
        },
    },
    "actions":{
        execute(params) {
            return ams.utils.sendRequest(this,{
                "method": "POST",
                "url": "/executeHttpRequest",
                "data": params.$prevReturn
            }, "请求执行完毕");
        },
        copyRequestBody(params) {
            let row = params.$prevReturn;
            let content = row["method"]+" "+row["url"]+"\n\n"+row["requestBody"];
            setClipBoard(content);
            this.$message.success("请求内容已复制到剪贴板");
        },
        copyResponseBody(params) {
            let row = params.$prevReturn;
            let responseBody = row["responseBody"].replace("\r\n", "\n");
            setClipBoard(responseBody);
            this.$message.success("响应内容已复制到剪贴板");
        },
    }
};