package cn.schoolwow.ams.util;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AMSUtil {
    private static Logger logger = LoggerFactory.getLogger(AMSUtil.class);

    /**获取指定目录下所有文件*/
    public static List<String> getJavascriptResourcePathList(String path) throws IOException {
        ClassPathResource resource = new ClassPathResource(path);
        if(!resource.exists()){
            return new ArrayList<>();
        }
        URL url = resource.getURI().toURL();
        String prefix = path.substring(path.lastIndexOf("/")+1);
        List<String> resourcePathList = new ArrayList<>();
        switch (url.getProtocol()) {
            case "file": {
                File directory = new File(url.getFile());
                Files.walkFileTree(directory.toPath(), new SimpleFileVisitor<Path>() {
                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        File file = path.toFile();
                        if (file.getName().endsWith(".js")) {
                            String relativePath = file.getAbsolutePath().replace(directory.getAbsolutePath(), "").replace("\\", "/");
                            resourcePathList.add(prefix+relativePath);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            break;
            case "jar": {
                JarURLConnection jarURLConnection = (JarURLConnection) url.openConnection();
                if (null != jarURLConnection) {
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (null != jarFile) {
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry jarEntry = jarEntries.nextElement();
                            String jarEntryName = jarEntry.getName();
                            if(jarEntryName.startsWith("static")&&jarEntryName.contains(path)&&jarEntryName.endsWith(".js")){
                                resourcePathList.add(jarEntryName.substring(jarEntryName.indexOf("/")+1));
                            }
                        }
                    }
                }
            }
            break;
        }
        return resourcePathList;
    }

    /**分页和排序*/
    public static Condition pageAndSort(Condition condition, JSONObject amsListCondition) {
        //分页
        {
            int page = amsListCondition.containsKey("page")?amsListCondition.getInteger("page"):1;
            int pageSize = amsListCondition.containsKey("pageSize")?amsListCondition.getInteger("pageSize"):10;
            condition.page(page, pageSize);
        }
        //排序
        {
            String sortField = amsListCondition.getString("sortField");
            String sortOrder = amsListCondition.getString("sortOrder");
            if (StringUtils.isNoneBlank(sortField) && StringUtils.isNoneBlank(sortOrder)) {
                condition.order(sortField, sortOrder);
            }
        }
        amsListCondition.remove("page");
        amsListCondition.remove("pageSize");
        amsListCondition.remove("sortField");
        amsListCondition.remove("sortOrder");
        return condition;
    }

    /**添加数据库字段复杂查询*/
    public static void addCompositeQuery(Entity entity, Condition condition, JSONObject amsListCondition){
        Set<String> keySet = amsListCondition.keySet();
        for(String key:keySet){
            Property property = entity.getPropertyByFieldName(key);
            if(null==property){
                continue;
            }
            String value = amsListCondition.getString(key);
            condition.addCompositeQuery(key, value);
        }
    }

    /**封装list结果*/
    public static JSONObject getAMSList(Collection list) {
        JSONObject amsList = new JSONObject();
        amsList.put("list", list);
        return amsList;
    }

    /**封装list结果*/
    public static JSONObject getAMSPagingList(PageVo pageVo) {
        JSONObject amsList = new JSONObject();
        amsList.put("list", pageVo.getArray());
        amsList.put("total", pageVo.getTotalSize());
        return amsList;
    }

}
