package cn.schoolwow.ams.advice;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSListener;
import org.apache.commons.lang3.Validate;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.annotation.Resource;

@ControllerAdvice
public class AMSResponseBodyAdvice implements ResponseBodyAdvice {
    @Resource
    private AMSListener amsListener;

    @Override
    public boolean supports(MethodParameter returnType, Class converterType) {
        Validate.notEmpty(amsListener.controllerPackageName(), "请指定AMS控制器所在包名!");
        String className = returnType.getDeclaringClass().getName();
        if (className.startsWith(amsListener.controllerPackageName())||className.startsWith("cn.schoolwow.ams")) {
            return true;
        }
        return false;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof AMSResult) {
            return body;
        }
        return new AMSResult(body);
    }
}
