ams.config({
    "resource": {
        requestInterceptor(options) {
            if (options.url.indexOf("?") > 0) {
                options.url += "&t=" + new Date().getTime();
            } else {
                options.url += "?t=" + new Date().getTime();
            }
            return options;
        },
        "api": {
            "contentType": "json"
        }
    },
    "defaultFieldConfig": {
        "text": {
            "style": {
                "cursor": "pointer"
            },
            "view": function (val, field, row) {
                if (null == val) {
                    return;
                }
                if (typeof (val) == "object" || typeof (val) == "array") {
                    val = JSON.stringify(val);
                }
                if (val.length > 50) {
                    //显示前20个和后30个字符
                    return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                }
                return val;
            },
        },
        "link":{
            "style": {
                "color": "blue"
            },
            "props": {
                "href": function(e) {
                    return e;
                },
                "target": "_blank"
            },
            "view": function (val, field, row) {
                if (null == val) {
                    return;
                }
                if (typeof (val) == "object" || typeof (val) == "array") {
                    val = JSON.stringify(val);
                }
                if (val.length > 50) {
                    //显示前20个和后30个字符
                    return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                }
                return val;
            },
        }
    },
});

function loadListBlock(block){
    let resourceName = block["tableName"]+"Resource";
    let resourceBlock = {
        "key": "id",
        "api": {
            "prefix": "/ams/api/"+block["daoName"]+"/"+block["tableName"],
            "list": "/list",
        },
        "fields": block["resourceFields"]
    };
    if(userBlockMap.hasOwnProperty(block["tableName"])){
        let userBlock = userBlockMap[block["tableName"]];
        if(userBlock.hasOwnProperty("resource")){
            let resource = userBlock["resource"];
            for(let prop in resource){
                resourceBlock[prop] = Object.assign(resourceBlock[prop], resource[prop]);
            }
            delete userBlock["resource"];
        }
    }
    ams.resource(resourceName, resourceBlock);

    let listBlock = {
        "resource": block["tableName"]+"Resource",
        "type": "list",
        "ctx": "view",
        "events": {
            "init": "@list"
        },
        "props": {
            "empty-text": "暂无记录",
        },
        "sorts": {},
        "expand": {},
        "options": {
            "multipleSelect": true,
        },
        "operations":{

        },
        "actions": {
            copyRow(params) {
                let row = params.$prevReturn;
                setClipBoard(JSON.stringify(row));
                this.$message.success("行数据已复制到剪贴板");
            },
            copyException(params) {
                let row = params.$prevReturn;
                let exception = row.exception.replace("\r\n", "\n");
                setClipBoard(exception);
                this.$message.success("异常信息已复制到剪贴板");
            },
        }
    };
    listBlock["operations"] = block["operationFields"];

    for(let prop in block["resourceFields"]){
        listBlock["sorts"][prop] = true;
        listBlock["expand"][prop] = true;
        if(prop==="id"){
            listBlock["data"] = {
                "searchs": {
                    "sortField": "id",
                    "sortOrder": "desc"
                }
            };
        }
    }

    if(userBlockMap.hasOwnProperty(block["tableName"])){
        let userBlock = userBlockMap[block["tableName"]];
        for(let prop in userBlock){
            listBlock[prop] = Object.assign(listBlock[prop], userBlock[prop]);
        }
    }

    listBlock["operations"] = Object.assign(listBlock["operations"], {
        "tableHeader": {
            "slot": "rightTop",
            "type": "filter",
            "label": "表头管理",
            "props": {
                "type": "primary",
            },
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        },
        "copyRow": {
            "type": "button",
            "label": "复制行",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "event": "copyRow"
        },
        "copyException": {
            "type": "button",
            "label": "复制异常",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "show": function(row){
                if(row.hasOwnProperty("exception")){
                    return true;
                }
                return false;
            },
            "event": "copyException"
        },
    });

    let blockName = block["daoName"]+"_"+block["tableName"]+"_listBlock";
    ams.block(blockName, listBlock);
}

function handleRoute(routes){
    for(let i=0;i<routes.length;i++){
        routes[i]["meta"] = {
            "icon": "el-icon-menu"
        };
        if(!routes[i].hasOwnProperty("children")){
            let blockName = routes[i]["path"].substring(1)+"_listBlock";
            if(blockExists(blockName)){
                routes[i]["block"] = blockName;
            }else{
                routes[i]["block"] = routes[i]["path"].substring(1);
            }
        }else{
            handleRoute(routes[i]["children"]);
        }
    }
}

function blockExists(blockName){
    if(ams.blocks.hasOwnProperty(blockName)){
        return true;
    }
    return false;
}

function loadRouterBlock(){
    handleRoute(routes);

    ams.block("routerBlock", {
        "type": "router",
        "router": {
            "defaultBreadcrumb": false,
            "routes": routes
        }
    });
}

function setClipBoard(value) {
    let e = document.getElementById("clipboard");
    e.value = value;
    e.select();
    document.execCommand("copy");
}

function setClipBoardPlain(value) {
    value = value.replace("\r\n","\n");
    setClipBoard(value);
}