package cn.schoolwow.ams.listener;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.PageVo;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public interface AMSListListener {
    /**
     * 初始化blocks
     * */
    void initialBlocks(JSONArray blocks);

    /**
     * 获取DAO对象
     * */
    DAO getDAO(String daoName);

    /**
     * 执行数据库请求前
     * */
    void beforeExecuteCondition(String daoName, String tableName, Condition condition, JSONObject amsListCondition);

    /**
     * 执行数据库请求后
     * */
    void afterExecuteCondition(String daoName, String tableName, PageVo pageVo);

    /**
     * 增加实体类之前
     * */
    void beforeCreate(String daoName, String tableName, JSONObject createEntity);

    /**
     * 更新实体类之前
     * */
    void beforeEdit(String daoName, String tableName, JSONObject updateEntity);

    /**
     * 删除实体类之前
     * */
    void beforeDelete(String daoName, String tableName, JSONObject amsListCondition);
}
