/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.service;

import cn.schoolwow.ams.domain.BeforeEditOption;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dml.DatabaseManipulation;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;

public class DefaultAMSDispatcherService
implements AMSDispatcherService {
    private AMSListListener amsListListener;
    private Collection<AMSTableListener> amsTableListenerList;
    private Collection<AMSOperation> amsOperationList;
    private Collection<AMSRemoteSelect> amsRemoteSelectList;

    public DefaultAMSDispatcherService(ApplicationContext applicationContext) {
        this.amsListListener = (AMSListListener)applicationContext.getBeansOfType(AMSListListener.class).values().iterator().next();
        this.amsTableListenerList = applicationContext.getBeansOfType(AMSTableListener.class).values();
        this.amsOperationList = applicationContext.getBeansOfType(AMSOperation.class).values();
        this.amsRemoteSelectList = applicationContext.getBeansOfType(AMSRemoteSelect.class).values();
    }

    @Override
    public JSONObject list(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        Condition condition;
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for (Property property : entity.properties) {
                condition.addColumn(new String[]{property.column + " " + StringUtil.underline2Camel((String)property.column)});
            }
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        Optional<AMSTableListener> optional = Optional.ofNullable(this.getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> amsTableListener.beforeExecuteCondition(condition, amsListCondition));
        PageVo pageVo = condition.execute().getPagingList();
        optional.ifPresent(amsTableListener -> amsTableListener.afterExecuteCondition(condition, amsListCondition, pageVo));
        return AMSUtil.getAMSPagingList(pageVo);
    }

    @Override
    public void create(String projectName, String daoName, String tableName, JSONObject createEntity) {
        Optional<AMSTableListener> optional = Optional.ofNullable(this.getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> amsTableListener.beforeCreate(createEntity));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            Set keySet = createEntity.keySet();
            for (String key : keySet) {
                Object value = createEntity.get((Object)key);
                createEntity.put(StringUtil.camel2Underline((String)key), value);
                createEntity.remove((Object)key);
            }
            dao.insert(tableName, createEntity);
        } else {
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
        optional.ifPresent(amsTableListener -> amsTableListener.afterCreate(createEntity));
    }

    @Override
    public void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) {
        DAO dao;
        Entity entity;
        BeforeEditOption beforeEditOption = null;
        AMSTableListener amsTableListener = this.getAMSTableListener(daoName, tableName);
        if (null != amsTableListener) {
            beforeEditOption = amsTableListener.beforeEdit(updateEntity);
        }
        if (null == beforeEditOption) {
            beforeEditOption = new BeforeEditOption();
        }
        if (null == (entity = (dao = this.amsListListener.getDAO(daoName)).getEntity(tableName))) {
            Validate.isTrue((null != beforeEditOption.uniqueFieldNameArray && beforeEditOption.uniqueFieldNameArray.length > 0 ? 1 : 0) != 0, (String)"jsonObject\u683c\u5f0f\u66f4\u65b0,\u5fc5\u987b\u5236\u5b9a\u552f\u4e00\u5b57\u6bb5\u540d\u79f0\u5217\u8868!", (Object[])new Object[0]);
            Set keySet = updateEntity.keySet();
            for (String key : keySet) {
                Object value = updateEntity.get((Object)key);
                updateEntity.put(StringUtil.camel2Underline((String)key), value);
                updateEntity.remove((Object)key);
            }
            DatabaseManipulation dml = dao.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            if (null != beforeEditOption.partColumnArray && beforeEditOption.partColumnArray.length > 0) {
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            dml.updateType(beforeEditOption.updateType).update(tableName, updateEntity);
        } else {
            DatabaseManipulation dml = dao.updateType(UpdateType.UpdateByUniqueKey);
            if (null != beforeEditOption.partColumnArray && beforeEditOption.partColumnArray.length > 0) {
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            if (null != beforeEditOption.uniqueFieldNameArray && beforeEditOption.uniqueFieldNameArray.length > 0) {
                dml.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            }
            Object updateInstance = updateEntity.toJavaObject(entity.clazz);
            dml.updateType(beforeEditOption.updateType).update(updateInstance);
        }
        if (null != amsTableListener) {
            amsTableListener.afterEdit(beforeEditOption, updateEntity);
        }
    }

    @Override
    public void delete(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = null;
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        AMSTableListener amsTableListener = this.getAMSTableListener(daoName, tableName);
        if (null != amsTableListener) {
            amsTableListener.beforeDelete(condition, amsListCondition);
        }
        condition.clone().execute().delete();
        if (null != amsTableListener) {
            amsTableListener.afterDelete(condition, amsListCondition);
        }
    }

    @Override
    public JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) throws Exception {
        if (null == this.amsOperationList) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!dao:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
        }
        for (AMSOperation amsOperation : this.amsOperationList) {
            if (!daoName.equalsIgnoreCase(amsOperation.daoName()) || !tableName.equalsIgnoreCase(amsOperation.tableName()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{amsOperation.methodName()}) && !methodName.equalsIgnoreCase(amsOperation.methodName())) continue;
            return amsOperation.handle(methodName, requestBody);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!\u9879\u76ee\u540d:" + projectName + ",\u6570\u636e\u5e93\u540d:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
    }

    @Override
    public JSONArray remoteSelect(String projectName, String type, Map<String, String> amsListConditionMap) throws Exception {
        for (AMSRemoteSelect amsRemoteSelect : this.amsRemoteSelectList) {
            if (!type.equalsIgnoreCase(amsRemoteSelect.type())) continue;
            return amsRemoteSelect.getRemoteOption(amsListConditionMap);
        }
        throw new IllegalArgumentException("\u672a\u5339\u914d\u5230\u4e0b\u62c9\u6846\u9009\u9879!\u9879\u76ee\u540d:" + projectName + ",\u7c7b\u578b:" + type);
    }

    private AMSTableListener getAMSTableListener(String daoName, String tableName) {
        if (null == this.amsTableListenerList) {
            return null;
        }
        for (AMSTableListener amsTableListener : this.amsTableListenerList) {
            if (!amsTableListener.daoName().equals(daoName) || !amsTableListener.tableName().equals(tableName)) continue;
            return amsTableListener;
        }
        return null;
    }
}

