userBlockMap[projectName+"|common|sys@flow_record"] = {
    "resource": {
        "fields": {
            "requestData": {
                "type": "textarea",
                "label": "请求数据",
                "props": {
                    "placeholder": "请输入请求数据"
                },
                "get": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    return val;
                },
                "view": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    if (val.length > 50) {
                        //显示前20个和后30个字符
                        return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                    }
                    return val;
                },
            }
        }
    },
    "operations": {
        "executeFlow": {
            "type": "button",
            "label": "执行流程",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认执行吗? executeFlow"
        },
        "multipleExecuteFlow": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量执行流程",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认批量执行流程吗? multipleExecuteFlow"
        },
        "copyFlow": {
            "type": "button",
            "label": "复制流程",
            "props": {
                "type": "primary",
            },
            "event": "copyFlow list:1"
        },
        "create": {
            "slot": "rightTop",
            "type": "button",
            "label": "新增流程",
            "props": {
                "type": "primary",
            },
            "event": "addItemDialogAction list:1"
        },
        "update": {
            "type": "button",
            "label": "更新",
            "props": {
                "type": "warning",
            },
            "event": "editItemDialogAction list:1"
        },
        "delete": {
            "type": "button",
            "label": "删除",
            "props": {
                "type": "danger",
            },
            "event": "confirm:确认删除吗? delete list:1"
        },
        "multipleDelete": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量删除",
            "props": {
                "type": "danger",
            },
            "event": "confirm:确认批量删除吗? multipleDelete"
        },
    },
    "actions": {
        multipleDelete(params){
            let ids = ams.utils.getIdsString(params, "id");
            return ams.utils.sendRequest(this,{
                "method": "POST",
                "url": "/delete",
                "data": {
                    "id": "in:"+ids
                },
                "contentType": "form"
            }, "批量删除流程记录完成");
        },
        copyFlow(params){
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.addItemDialog(this,"/create",fields, {
                "path": "/create",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
        addItemDialogAction(params) {
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.addItemDialog(this,"/create",fields, {
                "path": "/create",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
        editItemDialogAction(params) {
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.editItemDialog(this,"/edit",fields, {
                "path": "/edit",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
        executeFlow(params) {
            let flowLogBlock = ams.utils.getBlockByTableName(projectName,"log@flow_log");
            let resource = ams.resources[flowLogBlock["resource"]];
            let row = params.$prevReturn;
            let data = {
                "name": row["name"],
                "requestData": row["requestData"],
                "flowNameList": row["flowNameList"],
            };
            return ams.utils.sendRequestWithPrefix(this,resource.api.prefix, {
                "method": "POST",
                "url": "/executeFlow",
                "data": data
            }, "流程执行完成");
        },
        multipleExecuteFlow(params) {
            let flowLogBlock = ams.utils.getBlockByTableName(projectName,"log@flow_log");
            let resource = ams.resources[flowLogBlock["resource"]];
            let array = params.$prevReturn;
            let flowList = [];
            for(let i=0;i<array.length;i++){
                let o = array[i];
                flowList.push({
                    "name": o["name"],
                    "requestData": o["requestData"],
                    "flowNameList": o["flowNameList"]
                });
            }
            return ams.utils.sendRequestWithPrefix(this,resource.api.prefix, {
                "method": "POST",
                "url": "/multipleExecuteFlow",
                "data": {
                    "flowList": flowList
                }
            }, "流程执行完成");
        }
    }
};