/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.domain.BeforeEditOption;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dml.DatabaseManipulation;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController {
    @Value(value="${spring.profiles.active}")
    private String activeProfile;
    @Resource
    private AMSListener amsListener;
    @Resource
    private AMSListListener amsListListener;
    @Resource
    private List<AMSTableListener> amsTableListenerList;
    @Resource
    private List<AMSOperation> amsOperationList;
    private JSONArray blocks = new JSONArray();
    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() throws IOException {
        this.amsListListener.initialBlocks(this.blocks);
        for (int i = 0; i < this.blocks.size(); ++i) {
            JSONObject block = this.blocks.getJSONObject(i);
            String uniqueKey = this.amsListener.projectName() + "|" + block.getString("daoName") + "|" + block.getString("tableName");
            block.put("uniqueKey", (Object)uniqueKey);
            block.put("resourceName", (Object)(uniqueKey + "|resource"));
            block.put("listBlockName", (Object)(uniqueKey + "|listBlock"));
        }
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/operation"));
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/page"));
    }

    @RequestMapping(value={"/config"})
    public JSONObject config() throws IOException {
        if (!"docker".equals(this.activeProfile)) {
            this.blocks.clear();
            this.scriptPathList.clear();
            this.postConstruct();
        }
        JSONObject config = new JSONObject();
        config.put("projectName", (Object)this.amsListener.projectName());
        config.put("applicationName", (Object)this.amsListener.applicationName());
        config.put("blocks", (Object)this.blocks);
        config.put("scriptPathList", this.scriptPathList);
        return config;
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) {
        Condition condition;
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for (Property property : entity.properties) {
                condition.addColumn(new String[]{property.column + " " + StringUtil.underline2Camel((String)property.column)});
            }
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        Optional<AMSTableListener> optional = Optional.ofNullable(this.getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> amsTableListener.beforeExecuteCondition(condition, amsListCondition));
        PageVo pageVo = condition.execute().getPagingList();
        optional.ifPresent(amsTableListener -> amsTableListener.afterExecuteCondition(condition, amsListCondition, pageVo));
        return AMSUtil.getAMSPagingList(pageVo);
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) {
        Optional<AMSTableListener> optional = Optional.ofNullable(this.getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> amsTableListener.beforeCreate(createEntity));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if (null == entity) {
            Set keySet = createEntity.keySet();
            for (String key : keySet) {
                Object value = createEntity.get((Object)key);
                createEntity.put(StringUtil.camel2Underline((String)key), value);
                createEntity.remove((Object)key);
            }
            dao.insert(tableName, createEntity);
        } else {
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
        optional.ifPresent(amsTableListener -> amsTableListener.afterCreate(createEntity));
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject updateEntity) {
        DAO dao;
        Entity entity;
        BeforeEditOption beforeEditOption = null;
        AMSTableListener amsTableListener = this.getAMSTableListener(daoName, tableName);
        if (null != amsTableListener) {
            beforeEditOption = amsTableListener.beforeEdit(updateEntity);
        }
        if (null == beforeEditOption) {
            beforeEditOption = new BeforeEditOption();
        }
        if (null == (entity = (dao = this.amsListListener.getDAO(daoName)).getEntity(tableName))) {
            Validate.isTrue((null != beforeEditOption.uniqueFieldNameArray && beforeEditOption.uniqueFieldNameArray.length > 0 ? 1 : 0) != 0, (String)"jsonObject\u683c\u5f0f\u66f4\u65b0,\u5fc5\u987b\u5236\u5b9a\u552f\u4e00\u5b57\u6bb5\u540d\u79f0\u5217\u8868!", (Object[])new Object[0]);
            Set keySet = updateEntity.keySet();
            for (String key : keySet) {
                Object value = updateEntity.get((Object)key);
                updateEntity.put(StringUtil.camel2Underline((String)key), value);
                updateEntity.remove((Object)key);
            }
            DatabaseManipulation dml = dao.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            if (null != beforeEditOption.partColumnArray && beforeEditOption.partColumnArray.length > 0) {
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            dml.updateType(beforeEditOption.updateType).update(tableName, updateEntity);
        } else {
            DatabaseManipulation dml = dao.updateType(UpdateType.UpdateByUniqueKey);
            if (null != beforeEditOption.partColumnArray && beforeEditOption.partColumnArray.length > 0) {
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            if (null != beforeEditOption.uniqueFieldNameArray && beforeEditOption.uniqueFieldNameArray.length > 0) {
                dml.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            }
            Object updateInstance = updateEntity.toJavaObject(entity.clazz);
            dml.updateType(beforeEditOption.updateType).update(updateInstance);
        }
        if (null != amsTableListener) {
            amsTableListener.afterEdit(beforeEditOption, updateEntity);
        }
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) {
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString(amsListConditionMap));
        DAO dao = this.amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = null;
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        } else {
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        AMSTableListener amsTableListener = this.getAMSTableListener(daoName, tableName);
        if (null != amsTableListener) {
            amsTableListener.beforeDelete(condition, amsListCondition);
        }
        condition.clone().execute().delete();
        if (null != amsTableListener) {
            amsTableListener.afterDelete(condition, amsListCondition);
        }
    }

    @RequestMapping(value={"/api/{daoName}/{tableName}/{methodName}"})
    public JSONObject dispatcherRequest(@PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        for (AMSOperation amsOperation : this.amsOperationList) {
            if (!daoName.equalsIgnoreCase(amsOperation.daoName()) || !tableName.equalsIgnoreCase(amsOperation.tableName()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{amsOperation.methodName()}) && !methodName.equalsIgnoreCase(amsOperation.methodName())) continue;
            return amsOperation.handle(methodName, requestBody);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!dao:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
    }

    private AMSTableListener getAMSTableListener(String daoName, String tableName) {
        for (AMSTableListener amsTableListener : this.amsTableListenerList) {
            if (!amsTableListener.daoName().equals(daoName) || !amsTableListener.tableName().equals(tableName)) continue;
            return amsTableListener;
        }
        return null;
    }
}

