function handleRoute(routes){
    for(let i=0;i<routes.length;i++){
        routes[i]["meta"] = {
            "icon": "el-icon-menu"
        };
        if(!routes[i].hasOwnProperty("children")){
            let blockName = routes[i]["path"].substring(1)+"|listBlock";
            if(blockExists(blockName)){
                routes[i]["block"] = blockName;
            }else{
                routes[i]["block"] = routes[i]["path"].substring(1);
            }
        }else{
            handleRoute(routes[i]["children"]);
        }
    }
}

function blockExists(blockName){
    if(ams.blocks.hasOwnProperty(blockName)){
        return true;
    }
    return false;
}

function loadRouterBlock(){
    handleRoute(routes);

    let routerBlock = {
        "type": "router",
        "router": {
            "defaultBreadcrumb": false,
            "routes": routes
        }
    };
    if(window.hasOwnProperty("routerBlockConfig")){
        let routerBlockConfig = window["routerBlockConfig"];
        Object.assign(routerBlock, routerBlockConfig);
    }
    ams.block("routerBlock", routerBlock);
}