function handleUserResourceBlock(block, resourceBlock){
    let commonBlock = null;
    let fullBlock = null;
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];
        if(tableName===block["tableName"]){
            if(daoName==="common"){
                commonBlock = userBlockMap[prop];
            }
            if(daoName===block["daoName"]){
                fullBlock = userBlockMap[prop];
            }
        }
    }
    let userBlock = null!=fullBlock?fullBlock:commonBlock;
    if(null!=userBlock&&userBlock.hasOwnProperty("resource")){
        let userResource = userBlock["resource"];
        for(let prop in userResource){
            resourceBlock[prop] = Object.assign(resourceBlock[prop], userResource[prop]);
        }
        delete userBlock["resource"];
    }
}

function handleUserBlock(block, listBlock){
    let commonBlock = null;
    let fullBlock = null;
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];
        if(tableName===block["tableName"]){
            if(daoName==="common"){
                commonBlock = userBlockMap[prop];
            }
            if(daoName===block["daoName"]){
                fullBlock = userBlockMap[prop];
            }
        }
    }
    let userBlock = null!=fullBlock?fullBlock:commonBlock;
    if(null!=userBlock){
        for(let prop in userBlock){
            listBlock[prop] = Object.assign(listBlock[prop], userBlock[prop]);
        }
    }
}

function loadResource(block) {
    let resourceBlock = {
        "key": block["id"],
        "api": {
            "prefix": "/ams/api/"+block["daoName"]+"/"+block["tableName"],
            "list": "/list",
            "create": "/create",
            "update": "/update",
            "delete": "/delete"
        },
        "fields": block["resourceFields"]
    };
    handleUserResourceBlock(block, resourceBlock);
    ams.resource(block["resourceName"], resourceBlock);
}

function loadListBlock(block){
    loadResource(block);

    let listBlock = {
        "resource": block["resourceName"],
        "type": "list",
        "ctx": "view",
        "props": {
            "empty-text": "暂无记录",
        },
        "sorts": {},
        "expand": {},
        "options": {
            "multipleSelect": true,
        },
        "operations":{

        },
        "actions": {
            copyRow(params) {
                let row = params.$prevReturn;
                setClipBoard(JSON.stringify(row));
                this.$message.success("行数据已复制到剪贴板");
            },
            multipleDelete(params){
                let idFieldName = block["id"];
                let ids = ams.utils.getIdsString(params, idFieldName);
                let data = {};
                data[idFieldName] = "in:"+ids;

                return ams.utils.sendRequest(this, {
                    "method": "POST",
                    "url": "/delete",
                    "data": data,
                    "contentType": "form"
                }, "删除记录完成!");
            }
        }
    };
    if(block["initList"]){
        listBlock["events"] = {
            "init": "@list"
        };
    }
    listBlock["operations"] = block["operationFields"];

    for(let prop in block["resourceFields"]){
        listBlock["sorts"][prop] = true;
        listBlock["expand"][prop] = true;
        if(prop==="id"){
            listBlock["data"] = {
                "searchs": {
                    "sortField": "id",
                    "sortOrder": "desc"
                }
            };
        }
    }

    handleUserBlock(block, listBlock);

    listBlock["operations"] = Object.assign(listBlock["operations"], {
        "tableHeader": {
            "slot": "rightTop",
            "type": "filter",
            "label": "表头管理",
            "props": {
                "type": "primary",
            },
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        },
        "copyRow": {
            "type": "button",
            "label": "复制行",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "event": "copyRow"
        },
    });
    ams.block(block["listBlockName"], listBlock);
}