userBlockMap[projectName+"|common|log@flow_log"] = {
    "operations": {
        "addFlowLogRowButton": {
            "type": "button",
            "label": "手动执行流程",
            "props": {
                "type": "primary",
            },
            "event": "addItemDialogAction list:1"
        },
        "executeFlow": {
            "type": "button",
            "label": "执行流程",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认执行吗? executeFlow list:1"
        },
        "addToFlowRecord": {
            "type": "button",
            "label": "添加到流程记录",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认添加吗? addToFlowRecord"
        },
    },
    "actions":{
        addItemDialogAction(params) {
            let row = params.$prevReturn;
            row.contextData = JSON.stringify(row.contextData);
            let fields = ams.utils.getResourceFields(this, ["name","requestData","flowNameList"]);
            return ams.utils.addItemDialog(this,"/executeFlow",fields);
        },
        executeFlow(params) {
            let row = params.$prevReturn;
            let data = {
                "name": row["name"],
                "requestData": row["requestData"],
                "flowNameList": row["flowNameList"],
            };
            return ams.utils.sendRequest(this,{
                "method": "POST",
                "url": "/executeFlow",
                "data": data
            }, "流程执行完成");
        },
        addToFlowRecord(params){
            let flowRecordBlock = ams.utils.getBlockByTableName("sys@flow_record");
            let resource = ams.resources[flowRecordBlock["resource"]];
            let row = params.$prevReturn;
            let data = {
                "name": row["name"],
                "requestData": JSON.parse(row["requestData"]),
                "flowNameList": row["flowNameList"],
            };
            return ams.utils.sendRequestWithPrefix(this,resource.api.prefix, {
                "method": "POST",
                "url": "/create",
                "data": data
            }, "流程记录添加完毕");
        }
    }
};