package cn.scbsi.sdk.sign;


import java.util.HashMap;
import java.util.Map;

/**
 * @author 曳戈泰尔
 * @version 1.0
 */
public class AppMd5 {


    public static String generateSign(String appId, String appSecret, String timeStamp) {

        // 构建需要签名的Map
        Map<String, String> map = new HashMap<>();
        map.put("appId", appId);
        map.put("timeStamp", timeStamp);

        // 生成签名
        return Md5Helper.createSign(map, appSecret);
    }

    public static String generateSign(Md5Data md5Data) {

        // 构建需要签名的Map
        Map<String, String> map = new HashMap<>();
        map.put("appId", md5Data.getAppId());
        map.put("timeStamp", md5Data.getTimeStamp());

        // 生成签名
        return Md5Helper.createSign(map, md5Data.getAppSecret());
    }


    public static Boolean verifySign(Md5Data md5Data) {

        // 构建需要验证签名的Map
        Map<String, String> map = new HashMap<>();
        map.put("appId", md5Data.getAppId());
        map.put("timeStamp", md5Data.getTimeStamp());
        map.put("sign", md5Data.getSign());

        // 验证签名
        return Md5Helper.isCorrectSign(map, md5Data.getAppSecret());
    }
}
