package cn.scbsi.sdk;

import cn.hutool.core.util.IdUtil;
import cn.scbsi.sdk.csr.CsrResponse;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.chainmaker.sdk.utils.CryptoUtils;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;


public class CsrUtils {

    private static final String PRIVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----\n";
    private static final String PRIVATE_KEY_END = "\n-----END PRIVATE KEY-----\n";
    private static final String CSR_BEGIN = "-----BEGIN CERTIFICATE REQUEST-----\n";
    private static final String CSR_END = "\n-----END CERTIFICATE REQUEST-----\n";

    private static final String locality = "Beijing";

    private static final String country = "CN";

    private static final String province = "Beijing";

    private static final String organizationalUnit = "client";



    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public static CsrResponse generateCsrAndPrivateKey(String organization) throws Exception {
        // 生成SM2密钥对
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        keyPairGenerator.initialize(sm2Spec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();



        //生成uuid
        String uuid = IdUtil.simpleUUID();
        // 构建证书主题
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.C, country);
        nameBuilder.addRDN(BCStyle.L, locality);
        nameBuilder.addRDN(BCStyle.ST, province);
        nameBuilder.addRDN(BCStyle.OU, organizationalUnit);
        nameBuilder.addRDN(BCStyle.O, organization);
        nameBuilder.addRDN(BCStyle.CN, uuid);
        X500Name subject = nameBuilder.build();

        // 创建CSR
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SM3withSM2").setProvider("BC").build(keyPair.getPrivate());
        PKCS10CertificationRequest csr = csrBuilder.build(signer);

        // 编码CSR和私钥
        String encodedPrivateKey = PRIVATE_KEY_BEGIN + Base64.toBase64String(keyPair.getPrivate().getEncoded()) + PRIVATE_KEY_END;
        String encodedCsr = CSR_BEGIN + Base64.toBase64String(csr.getEncoded()) + CSR_END;
        CsrResponse response = new CsrResponse();
        response.setPrivateKey(encodedPrivateKey);
        response.setCsr(encodedCsr);
        response.setCode(uuid);
        // 获取EVM地址
        String evmAddress = CryptoUtils.getEVMAddressFromPrivateKeyBytes(encodedPrivateKey.getBytes(), "SHA256");

        response.setAddress(evmAddress);
        return response;
    }

    /*public static void main(String[] args) {
        String xx = "-----BEGIN PRIVATE KEY-----\n" +
                "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgbWdAJP7re2gHEbsK\n" +
                "UM9QROC01kif1NWjzNUaI094I4egCgYIKoEcz1UBgi2hRANCAARgrjcLkirf1kwR\n" +
                "7kgvKCv3t55YcACi+qeZMfUji8848OMoaoZ9utQWuWjUtBhL//2BJmj3FHlDJfM4\n" +
                "ml5iS8Nl\n" +
                "-----END PRIVATE KEY-----";
        String evmAddress = CryptoUtils.getEVMAddressFromPrivateKeyBytes(xx.getBytes(), "SHA256");
        System.out.println(evmAddress);
    }*/
}
