/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.utils.other;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.util.Map;
import org.springframework.lang.Nullable;

public class LogUtil {
    public static String formatValue(@Nullable Object value, int maxLength) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            JSONValidator jsonValidator = JSONValidator.from((String)((String)value));
            if (jsonValidator.validate()) {
                JSONObject json = null;
                JSONValidator.Type type = jsonValidator.getType();
                if (type == JSONValidator.Type.Object) {
                    json = JSON.parseObject((String)((String)value));
                } else if (type == JSONValidator.Type.Array) {
                    json = JSON.parseArray((String)((String)value));
                }
                if (json != null) {
                    LogUtil.formatJson((JSON)json, maxLength);
                    return json.toJSONString();
                }
            }
            return StrUtil.brief((CharSequence)((String)value), (int)maxLength);
        }
        return LogUtil.formatValue(JSON.toJSONString((Object)value), maxLength);
    }

    private static void formatJson(JSON json, int maxLength) {
        block5: {
            block4: {
                if (!(json instanceof JSONArray)) break block4;
                JSONArray jsonArray = (JSONArray)json;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Object obj = jsonArray.get(i);
                    if (obj instanceof JSON) {
                        LogUtil.formatJson((JSON)obj, maxLength);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    String v = StrUtil.brief((CharSequence)((String)obj), (int)maxLength);
                    jsonArray.set(i, (Object)v);
                }
                break block5;
            }
            if (!(json instanceof JSONObject)) break block5;
            for (Map.Entry entry : ((JSONObject)json).entrySet()) {
                if (entry.getValue() instanceof JSON) {
                    LogUtil.formatJson((JSON)entry.getValue(), maxLength);
                    continue;
                }
                if (!(entry.getValue() instanceof String)) continue;
                String v = StrUtil.brief((CharSequence)((String)entry.getValue()), (int)maxLength);
                entry.setValue(v);
            }
        }
    }
}

