/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.utils.http;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.log.Log;
import cn.sanenen.sunutils.SunSetting;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    private static final Log log = Log.get();
    private static final int maxConnTotal = SunSetting.getMaxConnTotal();
    private static final long connectTimeout = SunSetting.getConnectTimeout();
    private static final long requestTimeout = SunSetting.getRequestTimeout();

    public static String post(String urlString, Map<String, Object> paramMap) throws IOException {
        try (Response response = OkHttpUtil.post(urlString, paramMap, null);){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    public static Response post(String urlString, Map<String, Object> paramMap, Map<String, Object> headerMap) throws IOException {
        Request.Builder post = new Request.Builder().url(urlString);
        if (MapUtil.isNotEmpty(headerMap)) {
            headerMap.forEach((k, v) -> post.addHeader(k, String.valueOf(v)));
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (MapUtil.isNotEmpty(paramMap)) {
            paramMap.forEach((k, v) -> builder.add(k, String.valueOf(v)));
        }
        post.post((RequestBody)builder.build());
        return OkHttpUtil.call(post.build());
    }

    public static String post(String urlString, String body) throws IOException {
        try (Response response = OkHttpUtil.post(urlString, body, null);){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    public static Response post(String urlString, String body, Map<String, Object> headerMap) throws IOException {
        Request.Builder post = new Request.Builder().url(urlString);
        if (MapUtil.isNotEmpty(headerMap)) {
            headerMap.forEach((k, v) -> post.addHeader(k, String.valueOf(v)));
        }
        RequestBody requestBody = RequestBody.create((byte[])body.getBytes(CharsetUtil.CHARSET_UTF_8));
        post.post(requestBody);
        return OkHttpUtil.call(post.build());
    }

    public static Response call(Request request) throws IOException {
        return Client.http.newCall(request).execute();
    }

    private static class Client {
        private static final OkHttpClient http = Client.createHttp();

        private Client() {
        }

        private static OkHttpClient createHttp() {
            X509ExtendedTrustManager trustManager = new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.error((Throwable)e);
            }
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(maxConnTotal);
            dispatcher.setMaxRequestsPerHost(maxConnTotal - 1);
            assert (sslContext != null);
            return new OkHttpClient.Builder().connectTimeout(connectTimeout, TimeUnit.SECONDS).readTimeout(requestTimeout, TimeUnit.SECONDS).sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManager).hostnameVerifier((hostname, session) -> true).dispatcher(dispatcher).build();
        }
    }
}

