/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.queue;

import cn.hutool.core.io.FileUtil;
import cn.hutool.log.Log;
import cn.sanenen.sunutils.queue.QueueConstant;
import cn.sanenen.sunutils.queue.SQueue;
import cn.sanenen.sunutils.queue.data.FileRunner;
import cn.sanenen.sunutils.utils.other.DbLog;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SMQ {
    private static final Log log = Log.get();
    private static final Map<String, SQueue> queueMap = new ConcurrentHashMap<String, SQueue>();
    private static final Map<String, Queue<String>> memoryQueueMap = new ConcurrentHashMap<String, Queue<String>>();
    private static volatile FileLock fileLock = null;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final FileRunner fileRunner = new FileRunner();
    private static int dataSize = 0x3200000;
    private static int memoryQueueSize = 50;
    private static String dbPath = "smq";

    private SMQ() {
    }

    public static void setting(String dbPath) {
        SMQ.setting(dbPath, 50, memoryQueueSize);
    }

    public static void setting(String dbPath, int logSize, int memoryQueueSize) {
        if (logSize > 2048) {
            throw new RuntimeException(logSize + ",\u4e0d\u53ef\u8d85\u8fc72G\u3002");
        }
        SMQ.dbPath = dbPath;
        dataSize = 0x100000 * logSize;
        SMQ.memoryQueueSize = memoryQueueSize;
        SMQ.isLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void isLock() {
        if (fileLock != null) {
            return;
        }
        Class<SMQ> clazz = SMQ.class;
        synchronized (SMQ.class) {
            if (fileLock != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                RandomAccessFile rwd;
                FileChannel channel;
                File file = new File(dbPath);
                if ((file.exists() || file.mkdirs()) && (fileLock = (channel = (rwd = new RandomAccessFile(FileUtil.file((File)file, (String)"lock.lock"), "rwd")).getChannel()).tryLock()) != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            throw new RuntimeException(dbPath + "\u76ee\u5f55\u5df2\u88ab\u4f7f\u7528\u3002");
        }
    }

    public static void close() {
        for (Map.Entry<String, Queue<String>> entry : memoryQueueMap.entrySet()) {
            String poll;
            Queue<String> queue = entry.getValue();
            if (queue.isEmpty()) continue;
            SQueue sQueue = SMQ.getSQueue(entry.getKey());
            while ((poll = queue.poll()) != null) {
                try {
                    sQueue.add(poll.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    DbLog.log("saveSQueue error:{}", poll);
                }
            }
        }
        for (SQueue sQueue : queueMap.values()) {
            sQueue.close();
        }
        fileRunner.close();
        executor.shutdown();
        log.info("close SQueue", new Object[0]);
    }

    public static String pop(String topic) {
        SMQ.isLock();
        try {
            Queue<String> queue;
            String poll;
            if (memoryQueueSize > 0 && (poll = (queue = SMQ.getQueue(topic)).poll()) != null) {
                return poll;
            }
            byte[] data = SMQ.getSQueue(topic).readNextAndRemove();
            if (data != null) {
                return new String(data, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void push(String topic, String data) {
        SMQ.isLock();
        try {
            Queue<String> queue;
            if (memoryQueueSize > 0 && (queue = SMQ.getQueue(topic)).size() <= memoryQueueSize) {
                queue.offer(data);
                return;
            }
            SMQ.getSQueue(topic).add(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long size(String topic) {
        SMQ.isLock();
        if (memoryQueueSize > 0) {
            return (long)SMQ.getQueue(topic).size() + SMQ.getSQueue(topic).getQueueSize();
        }
        return SMQ.getSQueue(topic).getQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SQueue getSQueue(String topic) {
        SQueue sQueue = queueMap.get(topic);
        if (sQueue == null) {
            String string = topic.intern();
            synchronized (string) {
                try {
                    sQueue = queueMap.get(topic);
                    if (sQueue == null) {
                        sQueue = new SQueue(dbPath + QueueConstant.FILE_SEPARATOR + topic, dataSize);
                        queueMap.put(topic, sQueue);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException("SQueue create or get error.");
                }
            }
        }
        return sQueue;
    }

    private static Queue<String> getQueue(String topic) {
        Queue<String> queue = memoryQueueMap.get(topic);
        if (queue != null) {
            return queue;
        }
        memoryQueueMap.putIfAbsent(topic, new ConcurrentLinkedQueue());
        return memoryQueueMap.get(topic);
    }

    static {
        executor.execute(fileRunner);
        Runtime.getRuntime().addShutdownHook(new Thread(SMQ::close));
    }
}

