/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.utils.redis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.nosql.redis.RedisDS;
import cn.hutool.log.Log;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.resps.ScanResult;

public class JedisUtil {
    protected final Log log = Log.get(this.getClass());
    public static final String OK = "OK";
    private JedisPool jedisPool;
    private RedisDS redisDS;
    private static String rpopBatchScriptSha = null;
    private static String limitScriptSha = null;
    private static String hsetIfExistScriptSha = null;

    public JedisUtil(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public JedisUtil(RedisDS redisDS) {
        this.redisDS = redisDS;
    }

    public void close() {
        if (this.jedisPool != null) {
            this.jedisPool.close();
        } else {
            this.redisDS.close();
        }
    }

    protected Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.redisDS.getJedis();
    }

    public Long del(String ... keys) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.del(keys);
            return l;
        }
    }

    public Boolean exists(String key) {
        try (Jedis jedis = this.getJedis();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public Long expire(String key, Long seconds) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.expire(key, seconds.longValue());
            return l;
        }
    }

    public Long renamenx(String oldkey, String newkey) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.renamenx(oldkey, newkey);
            return l;
        }
    }

    public Long ttl(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.ttl(key);
            return l;
        }
    }

    public String get(String key) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.get(key);
            return string;
        }
    }

    public void set(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            jedis.set(key, value);
        }
    }

    public void setex(String key, long seconds, String value) {
        try (Jedis jedis = this.getJedis();){
            jedis.setex(key, seconds, value);
        }
    }

    public Long setnx(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.setnx(key, value);
            return l;
        }
    }

    public boolean setnxex(String key, String value, long secondsToExpire) {
        try (Jedis jedis = this.getJedis();){
            boolean bl = OK.equals(jedis.set(key, value, SetParams.setParams().nx().ex(secondsToExpire)));
            return bl;
        }
    }

    public Long decr(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.decr(key);
            return l;
        }
    }

    public Long decrBy(String key, long decrement) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.decrBy(key, decrement);
            return l;
        }
    }

    public Long incr(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.incr(key);
            return l;
        }
    }

    public Long incrBy(String key, long increment) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.incrBy(key, increment);
            return l;
        }
    }

    public String getSet(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.getSet(key, value);
            return string;
        }
    }

    public Long hdel(String key, String field) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hdel(key, new String[]{field});
            return l;
        }
    }

    public Long hdel(String key, List<String> fields) {
        try (Jedis jedis = this.getJedis();){
            Pipeline pipelined = jedis.pipelined();
            for (String field : fields) {
                pipelined.hdel(key, new String[]{field});
            }
            pipelined.sync();
            pipelined.close();
        }
        return 1L;
    }

    public Boolean hexists(String key, String field) {
        try (Jedis jedis = this.getJedis();){
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
    }

    public String hget(String key, String field) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.hget(key, field);
            return string;
        }
    }

    public <T> T hget(String key, String field, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            String hget = jedis.hget(key, field);
            if (StrUtil.isBlank((CharSequence)hget)) {
                T t = null;
                return t;
            }
            Object object = JSON.parseObject((String)hget, clazz);
            return (T)object;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = this.getJedis();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }

    public long hincrBy(String key, String field, long value) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    public double hincrByFloat(String key, String field, double value) {
        try (Jedis jedis = this.getJedis();){
            double d = jedis.hincrByFloat(key, field, value);
            return d;
        }
    }

    public Set<String> hkeys(String key) {
        try (Jedis jedis = this.getJedis();){
            Set set = jedis.hkeys(key);
            return set;
        }
    }

    public Long hlen(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hlen(key);
            return l;
        }
    }

    public Long hset(String key, String field, String value) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    public long hset(String key, Map<String, String> hash) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.hset(key, hash);
            return l;
        }
    }

    public Long hsetnx(String key, String field, String value) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
    }

    public List<String> hvals(String key) {
        try (Jedis jedis = this.getJedis();){
            List list = jedis.hvals(key);
            return list;
        }
    }

    public void sadd(String key, String ... member) {
        try (Jedis jedis = this.getJedis();){
            jedis.sadd(key, member);
        }
    }

    public Long scard(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.scard(key);
            return l;
        }
    }

    public Boolean sismember(String key, String member) {
        try (Jedis jedis = this.getJedis();){
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
    }

    public Set<String> smembers(String key) {
        try (Jedis jedis = this.getJedis();){
            Set set = jedis.smembers(key);
            return set;
        }
    }

    public Long srem(String key, String ... member) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.srem(key, member);
            return l;
        }
    }

    public <T> T rpop(String key, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            String rpop = jedis.rpop(key);
            if (StrUtil.isBlank((CharSequence)rpop)) {
                T t = null;
                return t;
            }
            Object object = JSON.parseObject((String)rpop, clazz);
            return (T)object;
        }
    }

    public <T> List<T> rpop(String key, int count, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            List rpop = jedis.rpop(key, count);
            if (CollUtil.isEmpty((Collection)rpop)) {
                List<T> list = null;
                return list;
            }
            List list = rpop.stream().map(s -> JSON.parseObject((String)s, (Class)clazz)).collect(Collectors.toList());
            return list;
        }
    }

    public <T> List<T> rpopByPip(String key, long count, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            long size = jedis.llen(key);
            if (size <= 0L) {
                List<T> list = null;
                return list;
            }
            if (size < count) {
                count = size;
            }
            ArrayList<Response> responses = new ArrayList<Response>();
            Pipeline p = jedis.pipelined();
            int i = 0;
            while ((long)i < count) {
                responses.add(p.rpop(key));
                ++i;
            }
            p.sync();
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (Response response : responses) {
                String v = (String)response.get();
                if (!StrUtil.isNotBlank((CharSequence)v)) continue;
                try {
                    Object info = JSON.parseObject((String)v, clazz);
                    if (info == null) continue;
                    resultList.add(info);
                }
                catch (Exception e) {
                    this.log.error((Throwable)e, "json\u8f6c\u6362\u51fa\u9519,\u5df2\u8df3\u8fc7\u8be5\u6570\u636e:{}", new Object[]{v});
                }
            }
            p.close();
            ArrayList<Object> arrayList = resultList;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> rpopByLua(String key, long count, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            Object result;
            if (rpopBatchScriptSha == null) {
                rpopBatchScriptSha = jedis.scriptLoad("local key = KEYS[1]\nlocal maxnum = ARGV[1]\nlocal count = redis.call('llen',key)\nif tonumber(count) == 0 then\n   return nil\nend\nif tonumber(count) < tonumber(maxnum) then\n   maxnum = tonumber(count)\nend\nlocal result = {}\nfor i = 1,tonumber(maxnum) do\n    local val = redis.call('rpop',key)\n    if val == nil then\n        return result\n    else\n        result[i] = val\n    end\nend\nreturn result");
            }
            if (ObjectUtil.isEmpty((Object)(result = jedis.evalsha(rpopBatchScriptSha, Collections.singletonList(key), Collections.singletonList(String.valueOf(count)))))) {
                List<T> list = null;
                return list;
            }
            ArrayList<Object> results = new ArrayList<Object>(((List)result).size());
            for (Object obj : (List)result) {
                Object t = JSON.parseObject((String)String.valueOf(obj), clazz);
                results.add(t);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            rpopBatchScriptSha = null;
            throw e;
        }
    }

    public <T> Long lpush(String key, List<T> objects) {
        if (CollUtil.isEmpty(objects)) {
            return 0L;
        }
        try (Jedis jedis = this.getJedis();){
            String[] strings = (String[])objects.stream().map(v -> {
                if (ClassUtil.isSimpleValueType(v.getClass())) {
                    return String.valueOf(v);
                }
                return JSON.toJSONString((Object)v);
            }).toArray(String[]::new);
            Long l = jedis.lpush(key, strings);
            return l;
        }
    }

    public <T> Long lpush(String key, T t) {
        if (t == null) {
            return 0L;
        }
        try (Jedis jedis = this.getJedis();){
            if (ClassUtil.isSimpleValueType(t.getClass())) {
                Long l = jedis.lpush(key, new String[]{String.valueOf(t)});
                return l;
            }
            Long l = jedis.lpush(key, new String[]{JSON.toJSONString(t)});
            return l;
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, int count, String pattern) {
        try (Jedis jedis = this.getJedis();){
            ScanParams params = new ScanParams();
            params.count(Integer.valueOf(count));
            if (pattern != null) {
                params.match(pattern);
            }
            ScanResult scanResult = jedis.hscan(key, cursor, params);
            return scanResult;
        }
    }

    public ScanResult<String> scan(String cursor, int count, String pattern) {
        try (Jedis jedis = this.getJedis();){
            ScanParams scanParams = new ScanParams().match(pattern).count(Integer.valueOf(count));
            ScanResult scanResult = jedis.scan(cursor, scanParams);
            return scanResult;
        }
    }

    public List<Map.Entry<String, String>> hkeys(String key, String keys) {
        try (Jedis jedis = this.getJedis();){
            ScanResult hscan;
            ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams scanParams = new ScanParams().match(keys).count(Integer.valueOf(10000));
            do {
                hscan = jedis.hscan(key, cursor, scanParams);
                list.addAll(hscan.getResult());
            } while (!ScanParams.SCAN_POINTER_START.equals(cursor = hscan.getCursor()));
            ArrayList<Map.Entry<String, String>> arrayList = list;
            return arrayList;
        }
    }

    public Set<String> keys(String keys) {
        TreeSet<String> set = new TreeSet<String>();
        try (Jedis jedis = this.getJedis();){
            ScanResult scan;
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams scanParams = new ScanParams().match(keys).count(Integer.valueOf(10000));
            do {
                scan = jedis.scan(cursor, scanParams);
                set.addAll(scan.getResult());
            } while (!ScanParams.SCAN_POINTER_START.equals(cursor = scan.getCursor()));
        }
        return set;
    }

    public Long hdecrBy(String key, String hKey, long decrement) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hincrBy(key, hKey, -decrement);
            return l;
        }
    }

    public <T> List<T> hvals(String key, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            List hvals = jedis.hvals(key);
            if (CollUtil.isEmpty((Collection)hvals)) {
                List<T> list = null;
                return list;
            }
            List list = hvals.stream().map(v -> JSON.parseObject((String)v, (Class)clazz)).collect(Collectors.toList());
            return list;
        }
    }

    public List<String> lrangeAll(String key) {
        try (Jedis jedis = this.getJedis();){
            List lvals = jedis.lrange(key, 0L, -1L);
            if (CollUtil.isEmpty((Collection)lvals)) {
                List<String> list = null;
                return list;
            }
            List list = lvals;
            return list;
        }
    }

    public <T> List<T> lrangeAll(String key, Class<T> clazz) {
        List<String> lvals = this.lrangeAll(key);
        if (CollUtil.isEmpty(lvals)) {
            return null;
        }
        return lvals.stream().map(v -> JSON.parseObject((String)v, (Class)clazz)).collect(Collectors.toList());
    }

    public boolean lock(String lockKey, String appId) {
        return this.lock(lockKey, appId, 60L);
    }

    public boolean lock(String lockKey, String appId, long expireTime) {
        try (Jedis jedis = this.getJedis();){
            String v = jedis.get(lockKey);
            if (!appId.equals(v)) {
                if (v == null && jedis.setnx(lockKey, appId) == 1L) {
                    jedis.expire(lockKey, expireTime);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            jedis.expire(lockKey, expireTime);
            boolean bl = true;
            return bl;
        }
    }

    public void releaseLock(String lockKey, String appId) {
        try (Jedis jedis = this.getJedis();){
            String v = jedis.get(lockKey);
            if (appId.equals(v)) {
                jedis.del(lockKey);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long hLimit(String key, String field, long limitCount) {
        try (Jedis jedis = this.getJedis();){
            if (limitScriptSha == null) {
                limitScriptSha = jedis.scriptLoad("local key = KEYS[1]\nlocal field = KEYS[2]\nlocal limit = ARGV[1]\nlocal cur = redis.call('hget', key, field)\nif cur then\n    if tonumber(limit) <= tonumber(cur) then\n        return 1\n    end\nend\nredis.call('hincrBy', key, field, 1)\nreturn -1\n");
            }
            Object result = jedis.evalsha(limitScriptSha, Arrays.asList(key, field), Collections.singletonList(String.valueOf(limitCount)));
            long l = NumberUtil.parseInt((String)String.valueOf(result));
            return l;
        }
        catch (Exception e) {
            limitScriptSha = null;
            throw e;
        }
    }

    public long zadd(String key, double score, String member) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zadd(key, score, member);
            return l;
        }
    }

    public List<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try (Jedis jedis = this.getJedis();){
            List list = jedis.zrangeByScore(key, min, max, offset, count);
            return list;
        }
    }

    public long zrem(String expireKey, String ... members) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zrem(expireKey, members);
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long hsetIfExist(String key, String field, String value) {
        try (Jedis jedis = this.getJedis();){
            if (hsetIfExistScriptSha == null) {
                hsetIfExistScriptSha = jedis.scriptLoad("local key = KEYS[1]\nlocal field = KEYS[2]\nlocal newVal = ARGV[1]\nlocal oldVal = redis.call('hget',key,field)\nif oldVal then\n  redis.call('hset',key,field,newVal)\n  return 1\nelse\n  return 0\nend\n");
            }
            Object result = jedis.evalsha(hsetIfExistScriptSha, Arrays.asList(key, field), Collections.singletonList(String.valueOf(value)));
            long l = NumberUtil.parseInt((String)String.valueOf(result));
            return l;
        }
        catch (Exception e) {
            hsetIfExistScriptSha = null;
            throw e;
        }
    }
}

