/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.utils.other;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

public class ReflectUtil
extends cn.hutool.core.util.ReflectUtil {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final Log log = Log.get();

    public static <E> E invokeGetter(Object obj, String propertyName) {
        Object object = obj;
        for (String name : StrUtil.split((CharSequence)propertyName, (CharSequence)".")) {
            String getterMethodName = StrUtil.genGetter((CharSequence)name);
            object = ReflectUtil.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return (E)object;
    }

    public static <E> void invokeSetter(Object obj, String propertyName, E value) {
        Object object = obj;
        List names = StrUtil.split((CharSequence)propertyName, (CharSequence)".");
        for (int i = 0; i < names.size(); ++i) {
            if (i < names.size() - 1) {
                String getterMethodName = StrUtil.genGetter((CharSequence)((CharSequence)names.get(i)));
                object = ReflectUtil.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = StrUtil.genSetter((CharSequence)((CharSequence)names.get(i)));
            ReflectUtil.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static <E> E invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        if (obj == null || methodName == null) {
            return null;
        }
        Method method = ReflectUtil.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            log.debug("\u5728 [" + obj.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + methodName + "] \u65b9\u6cd5 ", new Object[0]);
            return null;
        }
        try {
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            String msg = "method: " + method + ", obj: " + obj + ", args: " + args + "";
            throw ReflectUtil.convertReflectionExceptionToUnchecked(msg, e);
        }
    }

    public static <E> E invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectUtil.getAccessibleMethodByName(obj, methodName, args.length);
        if (method == null) {
            log.debug("\u5728 [" + obj.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + methodName + "] \u65b9\u6cd5 ", new Object[0]);
            return null;
        }
        try {
            Class<?>[] cs = method.getParameterTypes();
            for (int i = 0; i < cs.length; ++i) {
                if (args[i] == null || args[i].getClass().equals(cs[i])) continue;
                if (cs[i] == String.class) {
                    args[i] = Convert.toStr((Object)args[i]);
                    if (!StrUtil.endWith((CharSequence)((String)args[i]), (CharSequence)".0")) continue;
                    args[i] = StrUtil.subBefore((CharSequence)((String)args[i]), (CharSequence)".0", (boolean)false);
                    continue;
                }
                if (cs[i] == Integer.class) {
                    args[i] = Convert.toInt((Object)args[i]);
                    continue;
                }
                if (cs[i] == Long.class) {
                    args[i] = Convert.toLong((Object)args[i]);
                    continue;
                }
                if (cs[i] == Double.class) {
                    args[i] = Convert.toDouble((Object)args[i]);
                    continue;
                }
                if (cs[i] == Float.class) {
                    args[i] = Convert.toFloat((Object)args[i]);
                    continue;
                }
                if (cs[i] == Date.class) {
                    if (args[i] instanceof String) {
                        args[i] = DateUtil.parseDateTime((CharSequence)((String)args[i]));
                        continue;
                    }
                    args[i] = args[i];
                    continue;
                }
                if (cs[i] != Boolean.TYPE && cs[i] != Boolean.class) continue;
                args[i] = Convert.toBool((Object)args[i]);
            }
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            String msg = "method: " + method + ", obj: " + obj + ", args: " + args + "";
            throw ReflectUtil.convertReflectionExceptionToUnchecked(msg, e);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Assert.notBlank((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        if (obj == null) {
            return null;
        }
        Assert.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                ReflectUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName, int argsNum) {
        if (obj == null) {
            return null;
        }
        Assert.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                ReflectUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectUtil.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.debug(clazz.getSimpleName() + "'s superclass not ParameterizedType", new Object[0]);
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.debug("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length, new Object[0]);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.debug(clazz.getSimpleName() + " not set the actual class on superclass generic parameter", new Object[0]);
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        if (instance == null) {
            throw new RuntimeException("Instance must not be null");
        }
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(String msg, Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(msg, e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(msg, ((InvocationTargetException)e).getTargetException());
        }
        return new RuntimeException(msg, e);
    }
}

