/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.thread;

import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BlockedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;

    public BlockedThreadPoolExecutor(int poolSize) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        try {
            this.semaphore.acquire();
            super.execute(command);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore.release();
    }
}

