/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.queue.data;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.log.Log;
import cn.sanenen.sunutils.queue.exception.FileFormatException;
import cn.sanenen.sunutils.queue.util.MappedByteBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class DataIndex {
    private static final Log log = Log.get();
    public static final int INDEX_LIMIT_LENGTH = 28;
    private RandomAccessFile dbRandFile;
    private FileChannel fc;
    private MappedByteBuffer mappedByteBuffer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean syncRunFlag = true;
    private ByteBuffer readerBuffer;
    private ByteBuffer writerBuffer;
    private int readerIndex = 1;
    private int writerIndex = 1;
    private AtomicLong size = new AtomicLong();

    public long getSize() {
        return this.size.get();
    }

    public DataIndex(String path) throws IOException, FileFormatException {
        File dbFile = new File(path);
        if (!dbFile.exists()) {
            if (!dbFile.createNewFile()) {
                throw new IOException("create Index File error.");
            }
            this.dbRandFile = new RandomAccessFile(dbFile, "rwd");
            this.dbRandFile.write("sunQueue".getBytes());
            this.dbRandFile.writeInt(3);
            this.dbRandFile.writeInt(this.readerIndex);
            this.dbRandFile.writeInt(this.writerIndex);
            this.dbRandFile.writeLong(0L);
        } else {
            this.dbRandFile = new RandomAccessFile(dbFile, "rwd");
            if (this.dbRandFile.length() < 28L) {
                throw new FileFormatException("index file format error");
            }
            byte[] b = new byte[28];
            this.dbRandFile.read(b);
            ByteBuffer buffer = ByteBuffer.wrap(b);
            b = new byte["sunQueue".getBytes().length];
            buffer.get(b);
            if (!"sunQueue".equals(new String(b))) {
                throw new FileFormatException("index file magic error");
            }
            if (3 != buffer.getInt()) {
                throw new FileFormatException("index file version error");
            }
            this.readerIndex = buffer.getInt();
            this.writerIndex = buffer.getInt();
            this.size.set(buffer.getLong());
        }
        this.fc = this.dbRandFile.getChannel();
        this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, 28L);
        this.readerBuffer = this.mappedByteBuffer.duplicate();
        this.writerBuffer = this.mappedByteBuffer.duplicate();
        this.executor.execute(new Sync());
    }

    public void putReaderIndex(int index) {
        this.readerBuffer.position(12);
        this.readerBuffer.putInt(index);
        this.readerIndex = index;
    }

    public void putWriterIndex(int index) {
        this.writerBuffer.position(16);
        this.writerBuffer.putInt(index);
        this.writerIndex = index;
    }

    public void incrementSize() {
        this.size.incrementAndGet();
    }

    public void decrementSize() {
        this.size.decrementAndGet();
    }

    public void close() {
        try {
            this.syncRunFlag = false;
            this.mappedByteBuffer.force();
            MappedByteBufferUtil.clean(this.mappedByteBuffer);
            this.fc.close();
            this.dbRandFile.close();
            this.fc = null;
            this.mappedByteBuffer = null;
            this.dbRandFile = null;
            this.executor.shutdown();
        }
        catch (IOException e) {
            log.error("close index file error:", new Object[]{e});
        }
    }

    public RandomAccessFile getDbRandFile() {
        return this.dbRandFile;
    }

    public FileChannel getFc() {
        return this.fc;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isSyncRunFlag() {
        return this.syncRunFlag;
    }

    public ByteBuffer getReaderBuffer() {
        return this.readerBuffer;
    }

    public ByteBuffer getWriterBuffer() {
        return this.writerBuffer;
    }

    public int getReaderIndex() {
        return this.readerIndex;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public void setDbRandFile(RandomAccessFile dbRandFile) {
        this.dbRandFile = dbRandFile;
    }

    public void setFc(FileChannel fc) {
        this.fc = fc;
    }

    public void setMappedByteBuffer(MappedByteBuffer mappedByteBuffer) {
        this.mappedByteBuffer = mappedByteBuffer;
    }

    public void setSyncRunFlag(boolean syncRunFlag) {
        this.syncRunFlag = syncRunFlag;
    }

    public void setReaderBuffer(ByteBuffer readerBuffer) {
        this.readerBuffer = readerBuffer;
    }

    public void setWriterBuffer(ByteBuffer writerBuffer) {
        this.writerBuffer = writerBuffer;
    }

    public void setReaderIndex(int readerIndex) {
        this.readerIndex = readerIndex;
    }

    public void setWriterIndex(int writerIndex) {
        this.writerIndex = writerIndex;
    }

    public void setSize(AtomicLong size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataIndex)) {
            return false;
        }
        DataIndex other = (DataIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSyncRunFlag() != other.isSyncRunFlag()) {
            return false;
        }
        if (this.getReaderIndex() != other.getReaderIndex()) {
            return false;
        }
        if (this.getWriterIndex() != other.getWriterIndex()) {
            return false;
        }
        RandomAccessFile this$dbRandFile = this.getDbRandFile();
        RandomAccessFile other$dbRandFile = other.getDbRandFile();
        if (this$dbRandFile == null ? other$dbRandFile != null : !this$dbRandFile.equals(other$dbRandFile)) {
            return false;
        }
        FileChannel this$fc = this.getFc();
        FileChannel other$fc = other.getFc();
        if (this$fc == null ? other$fc != null : !this$fc.equals(other$fc)) {
            return false;
        }
        MappedByteBuffer this$mappedByteBuffer = this.getMappedByteBuffer();
        MappedByteBuffer other$mappedByteBuffer = other.getMappedByteBuffer();
        if (this$mappedByteBuffer == null ? other$mappedByteBuffer != null : !((Object)this$mappedByteBuffer).equals(other$mappedByteBuffer)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        ByteBuffer this$readerBuffer = this.getReaderBuffer();
        ByteBuffer other$readerBuffer = other.getReaderBuffer();
        if (this$readerBuffer == null ? other$readerBuffer != null : !((Object)this$readerBuffer).equals(other$readerBuffer)) {
            return false;
        }
        ByteBuffer this$writerBuffer = this.getWriterBuffer();
        ByteBuffer other$writerBuffer = other.getWriterBuffer();
        if (this$writerBuffer == null ? other$writerBuffer != null : !((Object)this$writerBuffer).equals(other$writerBuffer)) {
            return false;
        }
        return this.getSize() == other.getSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSyncRunFlag() ? 79 : 97);
        result = result * 59 + this.getReaderIndex();
        result = result * 59 + this.getWriterIndex();
        RandomAccessFile $dbRandFile = this.getDbRandFile();
        result = result * 59 + ($dbRandFile == null ? 43 : $dbRandFile.hashCode());
        FileChannel $fc = this.getFc();
        result = result * 59 + ($fc == null ? 43 : $fc.hashCode());
        MappedByteBuffer $mappedByteBuffer = this.getMappedByteBuffer();
        result = result * 59 + ($mappedByteBuffer == null ? 43 : ((Object)$mappedByteBuffer).hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        ByteBuffer $readerBuffer = this.getReaderBuffer();
        result = result * 59 + ($readerBuffer == null ? 43 : ((Object)$readerBuffer).hashCode());
        ByteBuffer $writerBuffer = this.getWriterBuffer();
        result = result * 59 + ($writerBuffer == null ? 43 : ((Object)$writerBuffer).hashCode());
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        return result;
    }

    public String toString() {
        return "DataIndex(dbRandFile=" + this.getDbRandFile() + ", fc=" + this.getFc() + ", mappedByteBuffer=" + this.getMappedByteBuffer() + ", executor=" + this.getExecutor() + ", syncRunFlag=" + this.isSyncRunFlag() + ", readerBuffer=" + this.getReaderBuffer() + ", writerBuffer=" + this.getWriterBuffer() + ", readerIndex=" + this.getReaderIndex() + ", writerIndex=" + this.getWriterIndex() + ", size=" + this.getSize() + ")";
    }

    private class Sync
    implements Runnable {
        private Sync() {
        }

        @Override
        public void run() {
            while (DataIndex.this.syncRunFlag && DataIndex.this.mappedByteBuffer != null) {
                try {
                    DataIndex.this.mappedByteBuffer.position(20);
                    DataIndex.this.mappedByteBuffer.putLong(DataIndex.this.size.get());
                    DataIndex.this.mappedByteBuffer.force();
                }
                catch (Exception e) {
                    break;
                }
                ThreadUtil.sleep((long)10L);
            }
        }
    }
}

