/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.queue.data;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.log.Log;
import cn.sanenen.sunutils.queue.exception.FileEOFException;
import cn.sanenen.sunutils.queue.exception.FileFormatException;
import cn.sanenen.sunutils.queue.util.MappedByteBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DataEntity {
    private static final Log log = Log.get();
    public static final int DATA_START_POSITION = 24;
    public static final byte WRITE_SUCCESS = 1;
    public static final byte WRITE_FULL = 3;
    private RandomAccessFile raFile;
    private FileChannel fc;
    private MappedByteBuffer mappedByteBuffer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ByteBuffer readerBuffer;
    private ByteBuffer writerBuffer;
    private int currentFileNumber;
    private final int fileLimitLength;
    private int readerPosition = 24;
    private int writerPosition = 24;
    private int endPosition = -1;

    public DataEntity(String path, int fileNumber, int fileLimitLength) throws IOException, FileFormatException {
        this.currentFileNumber = fileNumber;
        File file = new File(path);
        if (!file.exists()) {
            this.fileLimitLength = fileLimitLength;
            if (!file.createNewFile()) {
                throw new IOException("create Index File error.");
            }
            this.raFile = new RandomAccessFile(file, "rwd");
            this.raFile.write("sunQueue".getBytes());
            this.raFile.writeInt(this.fileLimitLength);
            this.raFile.writeInt(this.readerPosition);
            this.raFile.writeInt(this.writerPosition);
            this.raFile.writeInt(this.endPosition);
        } else {
            this.raFile = new RandomAccessFile(file, "rwd");
            if (this.raFile.length() < 24L) {
                throw new FileFormatException("file length error");
            }
            byte[] header = new byte[24];
            this.raFile.read(header);
            ByteBuffer buffer = ByteBuffer.wrap(header);
            byte[] b = new byte["sunQueue".getBytes().length];
            buffer.get(b);
            if (!"sunQueue".equals(new String(b))) {
                throw new FileFormatException("file format error");
            }
            this.fileLimitLength = buffer.getInt();
            this.readerPosition = buffer.getInt();
            this.writerPosition = buffer.getInt();
            this.endPosition = buffer.getInt();
        }
        this.fc = this.raFile.getChannel();
        this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileLimitLength);
        this.readerBuffer = this.mappedByteBuffer.duplicate();
        this.writerBuffer = this.mappedByteBuffer.duplicate();
        this.executor.execute(new Sync());
    }

    public byte[] readNextAndRemove() throws FileEOFException {
        if (this.endPosition != -1 && this.readerPosition >= this.endPosition) {
            throw new FileEOFException("file eof");
        }
        if (this.endPosition == -1 && this.readerPosition >= this.writerPosition) {
            return null;
        }
        this.readerBuffer.position(this.readerPosition);
        int length = this.readerBuffer.getInt();
        byte[] b = new byte[length];
        this.readerBuffer.get(b);
        this.readerPosition += length + 4;
        this.readerBuffer.position(12);
        this.readerBuffer.putInt(this.readerPosition);
        return b;
    }

    public byte write(byte[] data) {
        int increment = data.length + 4;
        if (this.isFull(increment)) {
            this.mappedByteBuffer.position(20);
            this.mappedByteBuffer.putInt(this.writerPosition);
            this.endPosition = this.writerPosition;
            return 3;
        }
        this.writerBuffer.position(this.writerPosition);
        this.writerBuffer.putInt(data.length);
        this.writerBuffer.put(data);
        this.writerPosition += increment;
        this.writerBuffer.position(16);
        this.writerBuffer.putInt(this.writerPosition);
        return 1;
    }

    private boolean isFull(int increment) {
        return this.fileLimitLength < this.writerPosition + increment;
    }

    public void close() {
        try {
            if (this.mappedByteBuffer == null) {
                return;
            }
            this.mappedByteBuffer.force();
            MappedByteBufferUtil.clean(this.mappedByteBuffer);
            this.mappedByteBuffer = null;
            this.executor.shutdown();
            this.fc.close();
            this.raFile.close();
        }
        catch (IOException e) {
            log.error("close logentity file error:", new Object[]{e});
        }
    }

    public RandomAccessFile getRaFile() {
        return this.raFile;
    }

    public FileChannel getFc() {
        return this.fc;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ByteBuffer getReaderBuffer() {
        return this.readerBuffer;
    }

    public ByteBuffer getWriterBuffer() {
        return this.writerBuffer;
    }

    public int getCurrentFileNumber() {
        return this.currentFileNumber;
    }

    public int getFileLimitLength() {
        return this.fileLimitLength;
    }

    public int getReaderPosition() {
        return this.readerPosition;
    }

    public int getWriterPosition() {
        return this.writerPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setRaFile(RandomAccessFile raFile) {
        this.raFile = raFile;
    }

    public void setFc(FileChannel fc) {
        this.fc = fc;
    }

    public void setMappedByteBuffer(MappedByteBuffer mappedByteBuffer) {
        this.mappedByteBuffer = mappedByteBuffer;
    }

    public void setReaderBuffer(ByteBuffer readerBuffer) {
        this.readerBuffer = readerBuffer;
    }

    public void setWriterBuffer(ByteBuffer writerBuffer) {
        this.writerBuffer = writerBuffer;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.currentFileNumber = currentFileNumber;
    }

    public void setReaderPosition(int readerPosition) {
        this.readerPosition = readerPosition;
    }

    public void setWriterPosition(int writerPosition) {
        this.writerPosition = writerPosition;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEntity)) {
            return false;
        }
        DataEntity other = (DataEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentFileNumber() != other.getCurrentFileNumber()) {
            return false;
        }
        if (this.getFileLimitLength() != other.getFileLimitLength()) {
            return false;
        }
        if (this.getReaderPosition() != other.getReaderPosition()) {
            return false;
        }
        if (this.getWriterPosition() != other.getWriterPosition()) {
            return false;
        }
        if (this.getEndPosition() != other.getEndPosition()) {
            return false;
        }
        RandomAccessFile this$raFile = this.getRaFile();
        RandomAccessFile other$raFile = other.getRaFile();
        if (this$raFile == null ? other$raFile != null : !this$raFile.equals(other$raFile)) {
            return false;
        }
        FileChannel this$fc = this.getFc();
        FileChannel other$fc = other.getFc();
        if (this$fc == null ? other$fc != null : !this$fc.equals(other$fc)) {
            return false;
        }
        MappedByteBuffer this$mappedByteBuffer = this.getMappedByteBuffer();
        MappedByteBuffer other$mappedByteBuffer = other.getMappedByteBuffer();
        if (this$mappedByteBuffer == null ? other$mappedByteBuffer != null : !((Object)this$mappedByteBuffer).equals(other$mappedByteBuffer)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        ByteBuffer this$readerBuffer = this.getReaderBuffer();
        ByteBuffer other$readerBuffer = other.getReaderBuffer();
        if (this$readerBuffer == null ? other$readerBuffer != null : !((Object)this$readerBuffer).equals(other$readerBuffer)) {
            return false;
        }
        ByteBuffer this$writerBuffer = this.getWriterBuffer();
        ByteBuffer other$writerBuffer = other.getWriterBuffer();
        return !(this$writerBuffer == null ? other$writerBuffer != null : !((Object)this$writerBuffer).equals(other$writerBuffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentFileNumber();
        result = result * 59 + this.getFileLimitLength();
        result = result * 59 + this.getReaderPosition();
        result = result * 59 + this.getWriterPosition();
        result = result * 59 + this.getEndPosition();
        RandomAccessFile $raFile = this.getRaFile();
        result = result * 59 + ($raFile == null ? 43 : $raFile.hashCode());
        FileChannel $fc = this.getFc();
        result = result * 59 + ($fc == null ? 43 : $fc.hashCode());
        MappedByteBuffer $mappedByteBuffer = this.getMappedByteBuffer();
        result = result * 59 + ($mappedByteBuffer == null ? 43 : ((Object)$mappedByteBuffer).hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        ByteBuffer $readerBuffer = this.getReaderBuffer();
        result = result * 59 + ($readerBuffer == null ? 43 : ((Object)$readerBuffer).hashCode());
        ByteBuffer $writerBuffer = this.getWriterBuffer();
        result = result * 59 + ($writerBuffer == null ? 43 : ((Object)$writerBuffer).hashCode());
        return result;
    }

    public String toString() {
        return "DataEntity(raFile=" + this.getRaFile() + ", fc=" + this.getFc() + ", mappedByteBuffer=" + this.getMappedByteBuffer() + ", executor=" + this.getExecutor() + ", readerBuffer=" + this.getReaderBuffer() + ", writerBuffer=" + this.getWriterBuffer() + ", currentFileNumber=" + this.getCurrentFileNumber() + ", fileLimitLength=" + this.getFileLimitLength() + ", readerPosition=" + this.getReaderPosition() + ", writerPosition=" + this.getWriterPosition() + ", endPosition=" + this.getEndPosition() + ")";
    }

    private class Sync
    implements Runnable {
        private Sync() {
        }

        @Override
        public void run() {
            while (DataEntity.this.mappedByteBuffer != null) {
                try {
                    DataEntity.this.mappedByteBuffer.force();
                }
                catch (Exception e) {
                    break;
                }
                ThreadUtil.sleep((long)10L);
            }
        }
    }
}

