/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.poi.excel;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.log.Log;
import cn.hutool.poi.excel.ExcelPicUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.sanenen.sunutils.poi.excel.Excel;
import cn.sanenen.sunutils.poi.excel.Excels;
import cn.sanenen.sunutils.utils.other.ReflectUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelHandler<T> {
    private static final Log log = Log.get();
    public static final double sheetSize = 65536.0;
    private String sheetName;
    private Excel.Type type;
    private ExcelReader reader;
    private Workbook wb;
    private Sheet sheet;
    private Map<String, CellStyle> styles;
    private List<T> list;
    private List<Object[]> fields;
    private short maxHeight;
    private Map<Integer, Double> statistics = new HashMap<Integer, Double>();
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("######0.00");
    public Class<T> clazz;

    public ExcelHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void init(List<T> list, String sheetName, Excel.Type type) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        this.list = list;
        this.sheetName = sheetName;
        this.type = type;
        this.createExcelField();
        this.createWorkbook();
    }

    public List<T> importExcel(InputStream is) throws Exception {
        return this.importExcel("", is);
    }

    /*
     * WARNING - void declaration
     */
    public List<T> importExcel(String sheetName, InputStream is) throws Exception {
        this.type = Excel.Type.IMPORT;
        ArrayList<Object> list = new ArrayList<Object>();
        this.reader = StrUtil.isNotBlank((CharSequence)sheetName) ? ExcelUtil.getReader((InputStream)is, (String)sheetName) : ExcelUtil.getReader((InputStream)is);
        this.wb = this.reader.getWorkbook();
        Sheet sheet = this.reader.getSheet();
        Map pictures = ExcelPicUtil.getPicMap((Workbook)this.wb, (int)this.wb.getSheetIndex(sheet));
        int rows = sheet.getLastRowNum();
        if (rows > 0) {
            void var11_15;
            HashMap<String, Integer> cellMap = new HashMap<String, Integer>();
            Row heard = sheet.getRow(0);
            for (int i = 0; i < heard.getPhysicalNumberOfCells(); ++i) {
                Cell cell = heard.getCell(i);
                if (Objects.nonNull(cell)) {
                    String string = CellUtil.getCellValue((Cell)cell).toString();
                    cellMap.put(string, i);
                    continue;
                }
                cellMap.put(null, i);
            }
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (Field field : allFields) {
                Excel attr = field.getAnnotation(Excel.class);
                if (attr == null || attr.type() != Excel.Type.ALL && attr.type() != this.type) continue;
                field.setAccessible(true);
                Integer column = (Integer)cellMap.get(attr.name());
                if (column == null) continue;
                fieldsMap.put(column, field);
            }
            boolean bl = true;
            while (var11_15 <= rows) {
                Row row = sheet.getRow((int)var11_15);
                if (!this.isRowEmpty(row)) {
                    Object entity = null;
                    for (Map.Entry entry : fieldsMap.entrySet()) {
                        Object val = CellUtil.getCellValue((Cell)CellUtil.getCell((Row)row, (int)((Integer)entry.getKey())));
                        entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                        Field field = (Field)entry.getValue();
                        Class<?> fieldType = field.getType();
                        if (String.class == fieldType) {
                            String dateFormat;
                            String s = Convert.toStr((Object)val);
                            val = StrUtil.endWith((CharSequence)s, (CharSequence)".0") ? StrUtil.subBefore((CharSequence)s, (CharSequence)".0", (boolean)false) : (StrUtil.isNotEmpty((CharSequence)(dateFormat = field.getAnnotation(Excel.class).dateFormat())) ? DateUtil.format((Date)((Date)val), (String)dateFormat) : Convert.toStr((Object)val));
                        } else if ((Integer.TYPE == fieldType || Integer.class == fieldType) && StrUtil.isNumeric((CharSequence)Convert.toStr((Object)val))) {
                            val = Convert.toInt((Object)val);
                        } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                            val = Convert.toLong((Object)val);
                        } else if (Double.TYPE == fieldType || Double.class == fieldType) {
                            val = Convert.toDouble((Object)val);
                        } else if (Float.TYPE == fieldType || Float.class == fieldType) {
                            val = Convert.toFloat((Object)val);
                        } else if (BigDecimal.class == fieldType) {
                            val = Convert.toBigDecimal((Object)val);
                        } else if (Date.class == fieldType) {
                            if (val instanceof String) {
                                val = DateUtil.parseDate((CharSequence)((String)val));
                            } else if (val instanceof Double) {
                                val = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)((Double)val));
                            }
                        } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                            val = Convert.toBool((Object)val, (Boolean)false);
                        }
                        Excel attr = field.getAnnotation(Excel.class);
                        String propertyName = field.getName();
                        if (StrUtil.isNotEmpty((CharSequence)attr.targetAttr())) {
                            propertyName = field.getName() + "." + attr.targetAttr();
                        } else if (StrUtil.isNotEmpty((CharSequence)attr.readConverterExp())) {
                            val = ExcelHandler.reverseByExp(Convert.toStr((Object)val), attr.readConverterExp(), attr.separator());
                        } else if (Excel.ColumnType.IMAGE == attr.cellType() && ObjectUtil.isNotEmpty((Object)pictures)) {
                            PictureData image = (PictureData)pictures.get(row.getRowNum() + "_" + entry.getKey());
                            byte[] data = image.getData();
                            val = Base64.encode((byte[])data);
                        }
                        ReflectUtil.invokeSetter(entity, propertyName, val);
                    }
                    list.add(entity);
                }
                ++var11_15;
            }
        }
        return list;
    }

    public Workbook exportExcel(List<T> list, String sheetName) {
        this.init(list, sheetName, Excel.Type.EXPORT);
        return this.exportExcel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletResponse response) {
        Object out = null;
        try {
            this.writeSheet();
            this.wb.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", new Object[]{e.getMessage()});
        }
        finally {
            IoUtil.close((Closeable)this.wb);
        }
    }

    public void exportExcel(HttpServletResponse response, List<T> list, String sheetName) {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)(sheetName + ".xlsx"), (Charset)CharsetUtil.CHARSET_UTF_8)}));
        this.init(list, sheetName, Excel.Type.EXPORT);
        this.exportExcel(response);
    }

    public Workbook importTemplateExcel(String sheetName) {
        this.init(null, sheetName, Excel.Type.IMPORT);
        return this.exportExcel();
    }

    public void importTemplateExcel(HttpServletResponse response, String sheetName) {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)(sheetName + ".xlsx"), (Charset)CharsetUtil.CHARSET_UTF_8)}));
        this.init(null, sheetName, Excel.Type.IMPORT);
        this.exportExcel(response);
    }

    public static InputStream workbookToStream(Workbook workbook) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            workbook.write((OutputStream)out);
            byte[] bookByteAry = out.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bookByteAry);
            return byteArrayInputStream;
        }
    }

    public void exportExcel(OutputStream out) {
        try {
            this.writeSheet();
            this.wb.write(out);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", new Object[]{e.getMessage()});
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.wb);
        }
    }

    public Workbook exportExcel() {
        try {
            this.writeSheet();
            return this.wb;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", new Object[]{e.getMessage()});
            throw new UtilException("\u5bfc\u51faExcel\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff01");
        }
    }

    public void writeSheet() {
        double sheetNo = Math.ceil((double)this.list.size() / 65536.0);
        int index = 0;
        while ((double)index <= sheetNo) {
            this.createSheet(sheetNo, index);
            Row row = this.sheet.createRow(0);
            int column = 0;
            for (Object[] os : this.fields) {
                Excel excel = (Excel)os[1];
                this.createCell(excel, row, column++);
            }
            if (Excel.Type.EXPORT.equals((Object)this.type)) {
                this.fillExcelData(index, row);
                this.addStatisticsRow();
            }
            ++index;
        }
    }

    public void fillExcelData(int index, Row row) {
        int startNo = index * 65536;
        int endNo = Math.min(startNo + 65536, this.list.size());
        for (int i = startNo; i < endNo; ++i) {
            row = this.sheet.createRow(i + 1 - startNo);
            T vo = this.list.get(i);
            int column = 0;
            for (Object[] os : this.fields) {
                Field field = (Field)os[0];
                Excel excel = (Excel)os[1];
                field.setAccessible(true);
                this.addCell(excel, row, vo, field, column++);
            }
        }
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font totalFont = wb.createFont();
        totalFont.setFontName("Arial");
        totalFont.setFontHeightInPoints((short)10);
        style.setFont(totalFont);
        styles.put("total", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.LEFT);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.RIGHT);
        styles.put("data3", style);
        return styles;
    }

    public Cell createCell(Excel attr, Row row, int column) {
        Cell cell = row.createCell(column);
        cell.setCellValue(attr.name());
        this.setDataValidation(attr, row, column);
        cell.setCellStyle(this.styles.get("header"));
        return cell;
    }

    public void setCellVo(Object value, Excel attr, Cell cell) {
        if (Excel.ColumnType.STRING == attr.cellType()) {
            cell.setCellValue(Objects.isNull(value) ? attr.defaultValue() : value + attr.suffix());
        } else if (Excel.ColumnType.NUMERIC == attr.cellType()) {
            if (Objects.nonNull(value)) {
                cell.setCellValue(StrUtil.contains((CharSequence)Convert.toStr((Object)value), (CharSequence)".") ? Convert.toDouble((Object)value) : (double)Convert.toInt((Object)value).intValue());
            }
        } else if (Excel.ColumnType.IMAGE == attr.cellType()) {
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), cell.getRow().getRowNum(), (int)((short)(cell.getColumnIndex() + 1)), cell.getRow().getRowNum() + 1);
            String imageBase64 = Convert.toStr((Object)value);
            if (StrUtil.isNotEmpty((CharSequence)imageBase64)) {
                byte[] data = Base64.decode((CharSequence)imageBase64);
                ExcelHandler.getDrawingPatriarch(cell.getSheet()).createPicture((ClientAnchor)anchor, cell.getSheet().getWorkbook().addPicture(data, this.getImageType(data)));
            }
        }
    }

    public static Drawing<?> getDrawingPatriarch(Sheet sheet) {
        if (sheet.getDrawingPatriarch() == null) {
            sheet.createDrawingPatriarch();
        }
        return sheet.getDrawingPatriarch();
    }

    public int getImageType(byte[] value) {
        String type = ExcelHandler.getFileExtendName(value);
        if ("JPG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        return 5;
    }

    public static String getFileExtendName(byte[] photoByte) {
        String strFileExtendName = "JPG";
        if (photoByte[0] == 71 && photoByte[1] == 73 && photoByte[2] == 70 && photoByte[3] == 56 && (photoByte[4] == 55 || photoByte[4] == 57) && photoByte[5] == 97) {
            strFileExtendName = "GIF";
        } else if (photoByte[6] == 74 && photoByte[7] == 70 && photoByte[8] == 73 && photoByte[9] == 70) {
            strFileExtendName = "JPG";
        } else if (photoByte[0] == 66 && photoByte[1] == 77) {
            strFileExtendName = "BMP";
        } else if (photoByte[1] == 80 && photoByte[2] == 78 && photoByte[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    public void setDataValidation(Excel attr, Row row, int column) {
        if (attr.name().indexOf("\u6ce8\uff1a") >= 0) {
            this.sheet.setColumnWidth(column, 6000);
        } else {
            this.sheet.setColumnWidth(column, (int)((attr.width() + 0.72) * 256.0));
        }
        if (StrUtil.isNotEmpty((CharSequence)attr.prompt())) {
            this.setXSSFPrompt(this.sheet, "", attr.prompt(), 1, 100, column, column);
        }
        if (attr.combo().length > 0) {
            this.setXSSFValidation(this.sheet, attr.combo(), 1, 100, column, column);
        }
    }

    public Cell addCell(Excel attr, Row row, T vo, Field field, int column) {
        Cell cell = null;
        try {
            row.setHeight(this.maxHeight);
            if (attr.isExport()) {
                cell = row.createCell(column);
                int align = attr.align().value();
                cell.setCellStyle(this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : "")));
                Object value = this.getTargetValue(vo, field, attr);
                String dateFormat = attr.dateFormat();
                String readConverterExp = attr.readConverterExp();
                String separator = attr.separator();
                if (StrUtil.isNotEmpty((CharSequence)dateFormat) && Objects.nonNull(value)) {
                    cell.setCellValue(DateUtil.format((Date)((Date)value), (String)dateFormat));
                } else if (StrUtil.isNotEmpty((CharSequence)readConverterExp) && Objects.nonNull(value)) {
                    cell.setCellValue(ExcelHandler.convertByExp(Convert.toStr((Object)value), readConverterExp, separator));
                } else if (value instanceof BigDecimal && -1 != attr.scale()) {
                    cell.setCellValue(((BigDecimal)value).setScale(attr.scale(), attr.roundingMode()).toString());
                } else {
                    this.setCellVo(value, attr, cell);
                }
                this.addStatisticsData(column, Convert.toStr((Object)value), attr);
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25{}", new Object[]{e});
        }
        return cell;
    }

    public void setXSSFPrompt(Sheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createCustomConstraint("DD1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidation dataValidation = helper.createValidation(constraint, regions);
        dataValidation.createPromptBox(promptTitle, promptContent);
        dataValidation.setShowPromptBox(true);
        sheet.addValidationData(dataValidation);
    }

    public void setXSSFValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions;
        DataValidationConstraint constraint;
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidation dataValidation = helper.createValidation(constraint = helper.createExplicitListConstraint(textlist), regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StrUtil.containsAny((CharSequence)separator, (CharSequence[])new CharSequence[]{propertyValue})) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StrUtil.strip((CharSequence)propertyString.toString(), null, (CharSequence)separator);
    }

    public static String reverseByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StrUtil.containsAny((CharSequence)separator, (CharSequence[])new CharSequence[]{propertyValue})) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[1].equals(value)) continue;
                    propertyString.append(itemArray[0]).append(separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[1].equals(propertyValue)) continue;
            return itemArray[0];
        }
        return StrUtil.strip((CharSequence)propertyString.toString(), null, (CharSequence)separator);
    }

    private void addStatisticsData(Integer index, String text, Excel entity) {
        if (entity != null && entity.isStatistics()) {
            Double temp = 0.0;
            if (!this.statistics.containsKey(index)) {
                this.statistics.put(index, temp);
            }
            try {
                temp = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.statistics.put(index, this.statistics.get(index) + temp);
        }
    }

    public void addStatisticsRow() {
        if (this.statistics.size() > 0) {
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            Set<Integer> keys = this.statistics.keySet();
            Cell cell = row.createCell(0);
            cell.setCellStyle(this.styles.get("total"));
            cell.setCellValue("\u5408\u8ba1");
            for (Integer key : keys) {
                cell = row.createCell(key.intValue());
                cell.setCellStyle(this.styles.get("total"));
                cell.setCellValue(DOUBLE_FORMAT.format(this.statistics.get(key)));
            }
            this.statistics.clear();
        }
    }

    public String encodingFilename(String filename) {
        filename = UUID.randomUUID().toString() + "_" + filename + ".xlsx";
        return filename;
    }

    private Object getTargetValue(T vo, Field field, Excel excel) throws Exception {
        Object o = field.get(vo);
        if (StrUtil.isNotEmpty((CharSequence)excel.targetAttr())) {
            String target = excel.targetAttr();
            if (target.contains(".")) {
                String[] targets;
                for (String name : targets = target.split("[.]")) {
                    o = this.getValue(o, name);
                }
            } else {
                o = this.getValue(o, target);
            }
        }
        return o;
    }

    private Object getValue(Object o, String name) throws Exception {
        if (Objects.nonNull(o) && StrUtil.isNotEmpty((CharSequence)name)) {
            Class<?> clazz = o.getClass();
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            o = field.get(o);
        }
        return o;
    }

    private void createExcelField() {
        this.fields = new ArrayList<Object[]>();
        ArrayList<Field> tempFields = new ArrayList<Field>();
        tempFields.addAll(Arrays.asList(this.clazz.getSuperclass().getDeclaredFields()));
        tempFields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        for (Field field : tempFields) {
            Excel[] excels;
            if (field.isAnnotationPresent(Excel.class)) {
                this.putToField(field, field.getAnnotation(Excel.class));
            }
            if (!field.isAnnotationPresent(Excels.class)) continue;
            Excels attrs = field.getAnnotation(Excels.class);
            for (Excel excel : excels = attrs.value()) {
                this.putToField(field, excel);
            }
        }
        this.fields = this.fields.stream().sorted(Comparator.comparing(objects -> ((Excel)objects[1]).sort())).collect(Collectors.toList());
        this.maxHeight = this.getRowHeight();
    }

    public short getRowHeight() {
        double maxHeight = 0.0;
        for (Object[] os : this.fields) {
            Excel excel = (Excel)os[1];
            maxHeight = Math.max(maxHeight, excel.height());
        }
        return (short)(maxHeight * 20.0);
    }

    private void putToField(Field field, Excel attr) {
        if (attr != null && (attr.type() == Excel.Type.ALL || attr.type() == this.type)) {
            this.fields.add(new Object[]{field, attr});
        }
    }

    public void createWorkbook() {
        this.wb = new SXSSFWorkbook(500);
    }

    public void createSheet(double sheetNo, int index) {
        this.sheet = this.wb.createSheet();
        this.styles = this.createStyles(this.wb);
        if (sheetNo == 0.0) {
            this.wb.setSheetName(index, this.sheetName);
        } else {
            this.wb.setSheetName(index, this.sheetName + index);
        }
    }

    public Object getCellValue(Row row, int column) {
        if (row == null) {
            return row;
        }
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (Objects.nonNull(cell)) {
                if (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA) {
                    val = cell.getNumericCellValue();
                    val = org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell) ? org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)((Double)val)) : ((Double)val % 1.0 != 0.0 ? new BigDecimal(val.toString()) : new DecimalFormat("0").format(val));
                } else if (cell.getCellType() == CellType.STRING) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == CellType.BOOLEAN) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == CellType.ERROR) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    private boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    public static Map<String, PictureData> getSheetPictures03(HSSFSheet sheet, HSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (!pictures.isEmpty()) {
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                int pictureIndex = pic.getPictureIndex() - 1;
                HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
                String picIndex = anchor.getRow1() + "_" + String.valueOf(anchor.getCol1());
                sheetIndexPicMap.put(picIndex, (PictureData)picData);
            }
            return sheetIndexPicMap;
        }
        return sheetIndexPicMap;
    }

    public static Map<String, PictureData> getSheetPictures07(XSSFSheet sheet, XSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String picIndex = ctMarker.getRow() + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }
}

